/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshallerExt;
import org.dashbuilder.dataset.json.DataSetLookupJSONMarshaller;
import org.dashbuilder.json.Json;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonException;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonValue;

public class DataSetDefJSONMarshaller {
    public static final String UUID = "uuid";
    public static final String NAME = "name";
    public static final String PROVIDER = "provider";
    public static final String ISPUBLIC = "isPublic";
    public static final String PUSH_ENABLED = "pushEnabled";
    public static final String PUSH_MAXSIZE = "pushMaxSize";
    public static final String COLUMNS = "columns";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_TYPE = "type";
    public static final String COLUMN_PATTERN = "pattern";
    public static final String FILTERS = "filters";
    public static final String ALL_COLUMNS = "allColumns";
    public static final String CACHE_ENABLED = "cacheEnabled";
    public static final String CACHE_MAXROWS = "cacheMaxRows";
    public static final String REFRESH_TIME = "refreshTime";
    public static final String REFRESH_ALWAYS = "refreshAlways";
    public static final List<String> ROOT_KEYS = Arrays.asList("uuid", "name", "provider", "isPublic", "pushEnabled", "pushMaxSize", "columns", "filters", "allColumns", "cacheEnabled", "cacheMaxRows", "refreshTime", "refreshAlways");
    protected DataSetProviderRegistry dataSetProviderRegistry;
    protected DataSetLookupJSONMarshaller dataSetLookupJSONMarshaller;

    public DataSetDefJSONMarshaller(DataSetProviderRegistry dataSetProviderRegistry) {
        this(dataSetProviderRegistry, DataSetLookupJSONMarshaller.get());
    }

    public DataSetDefJSONMarshaller(DataSetProviderRegistry dataSetProviderRegistry, DataSetLookupJSONMarshaller dataSetLookupJSONMarshaller) {
        this.dataSetProviderRegistry = dataSetProviderRegistry;
        this.dataSetLookupJSONMarshaller = dataSetLookupJSONMarshaller;
    }

    public DataSetDef fromJson(String jsonString) throws Exception {
        JsonObject json = Json.parse((String)jsonString);
        DataSetProviderType type = this.readProviderType(json);
        Object dataSetDef = type.createDataSetDef();
        ((DataSetDef)dataSetDef).setProvider(type);
        this.readGeneralSettings((DataSetDef)dataSetDef, json);
        DataSetDefJSONMarshallerExt marshaller = type.getJsonMarshaller();
        if (marshaller != null) {
            marshaller.fromJson(dataSetDef, json);
        } else {
            for (String key : json.keys()) {
                if (ROOT_KEYS.contains(key)) continue;
                String value = json.getString(key);
                ((DataSetDef)dataSetDef).setProperty(key, value);
            }
        }
        return dataSetDef;
    }

    public DataSetProviderType readProviderType(JsonObject json) throws Exception {
        String provider = json.getString(PROVIDER);
        if (DataSetDefJSONMarshaller.isBlank(provider)) {
            throw new IllegalArgumentException("Missing 'provider' property");
        }
        DataSetProviderType type = this.dataSetProviderRegistry.getProviderTypeByName(provider);
        if (type == null) {
            throw new IllegalArgumentException("Provider not supported: " + provider);
        }
        return type;
    }

    public DataSetDef readGeneralSettings(DataSetDef def, JsonObject json) throws Exception {
        JsonArray array;
        String uuid = json.getString(UUID);
        String name = json.getString(NAME);
        String isPublic = json.getString(ISPUBLIC);
        String pushEnabled = json.getString(PUSH_ENABLED);
        String pushMaxSize = json.getString(PUSH_MAXSIZE);
        String cacheEnabled = json.getString(CACHE_ENABLED);
        String cacheMaxRows = json.getString(CACHE_MAXROWS);
        String refreshTime = json.getString(REFRESH_TIME);
        String refreshAlways = json.getString(REFRESH_ALWAYS);
        String allColumns = json.getString(ALL_COLUMNS);
        if (!DataSetDefJSONMarshaller.isBlank(uuid)) {
            def.setUUID(uuid);
        }
        if (!DataSetDefJSONMarshaller.isBlank(name)) {
            def.setName(name);
        }
        if (!DataSetDefJSONMarshaller.isBlank(isPublic)) {
            def.setPublic(Boolean.parseBoolean(isPublic));
        }
        if (!DataSetDefJSONMarshaller.isBlank(pushEnabled)) {
            def.setPushEnabled(Boolean.parseBoolean(pushEnabled));
        }
        if (!DataSetDefJSONMarshaller.isBlank(pushMaxSize)) {
            def.setPushMaxSize(Integer.parseInt(pushMaxSize));
        }
        if (!DataSetDefJSONMarshaller.isBlank(cacheEnabled)) {
            def.setCacheEnabled(Boolean.parseBoolean(cacheEnabled));
        }
        if (!DataSetDefJSONMarshaller.isBlank(cacheMaxRows)) {
            def.setCacheMaxRows(Integer.parseInt(cacheMaxRows));
        }
        if (!DataSetDefJSONMarshaller.isBlank(refreshTime)) {
            def.setRefreshTime(refreshTime);
        }
        if (!DataSetDefJSONMarshaller.isBlank(refreshAlways)) {
            def.setRefreshAlways(Boolean.parseBoolean(refreshAlways));
        }
        if (!DataSetDefJSONMarshaller.isBlank(allColumns)) {
            def.setAllColumnsEnabled(Boolean.parseBoolean(allColumns));
        }
        if (json.has(COLUMNS)) {
            array = json.getArray(COLUMNS);
            for (int i = 0; i < array.length(); ++i) {
                JsonObject column = array.getObject(i);
                String columnId = column.getString(COLUMN_ID);
                String columnType = column.getString(COLUMN_TYPE);
                String columnPattern = column.getString(COLUMN_PATTERN);
                if (DataSetDefJSONMarshaller.isBlank(columnId)) {
                    throw new IllegalArgumentException("Column id. attribute is mandatory.");
                }
                if (DataSetDefJSONMarshaller.isBlank(columnType)) {
                    throw new IllegalArgumentException("Missing column 'type' attribute: " + columnId);
                }
                ColumnType type = ColumnType.TEXT;
                if (columnType.equalsIgnoreCase("label")) {
                    type = ColumnType.LABEL;
                } else if (columnType.equalsIgnoreCase("date")) {
                    type = ColumnType.DATE;
                } else if (columnType.equalsIgnoreCase("number")) {
                    type = ColumnType.NUMBER;
                }
                def.addColumn(columnId, type);
                if (DataSetDefJSONMarshaller.isBlank(columnPattern)) continue;
                def.setPattern(columnId, columnPattern);
            }
        }
        if (json.has(FILTERS)) {
            array = json.getArray(FILTERS);
            DataSetFilter dataSetFilter = this.dataSetLookupJSONMarshaller.parseFilterOperation(array);
            def.setDataSetFilter(dataSetFilter);
        }
        return def;
    }

    public String toJsonString(DataSetDef dataSetDef) throws JsonException {
        return this.toJsonObject(dataSetDef).toString();
    }

    public JsonObject toJsonObject(DataSetDef dataSetDef) throws JsonException {
        DataSetFilter filter;
        JsonArray columnsArray;
        List<DataColumnDef> columns;
        JsonObject json = Json.createObject();
        json.put(UUID, dataSetDef.getUUID());
        json.put(NAME, dataSetDef.getName());
        json.put(PROVIDER, dataSetDef.getProvider().getName());
        json.put(ISPUBLIC, dataSetDef.isPublic());
        json.put(CACHE_ENABLED, dataSetDef.isCacheEnabled());
        json.put(CACHE_MAXROWS, (double)dataSetDef.getCacheMaxRows().intValue());
        json.put(PUSH_ENABLED, dataSetDef.isPushEnabled());
        json.put(PUSH_MAXSIZE, (double)dataSetDef.getPushMaxSize().intValue());
        json.put(REFRESH_ALWAYS, dataSetDef.isRefreshAlways());
        json.put(REFRESH_TIME, dataSetDef.getRefreshTime());
        DataSetProviderType type = dataSetDef.getProvider();
        DataSetDefJSONMarshallerExt<DataSetDef> marshaller = type.getJsonMarshaller();
        if (marshaller != null) {
            marshaller.toJson(dataSetDef, json);
        }
        if ((columns = dataSetDef.getColumns()) != null && (columnsArray = this.toJsonObject(columns, dataSetDef)) != null) {
            json.put(COLUMNS, (JsonValue)columnsArray);
        }
        if ((filter = dataSetDef.getDataSetFilter()) != null) {
            try {
                JsonArray filters = this.dataSetLookupJSONMarshaller.formatColumnFilters(filter.getColumnFilterList());
                if (filters != null) {
                    json.put(FILTERS, (JsonValue)filters);
                }
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }
        if (marshaller == null) {
            for (String key : dataSetDef.getPropertyNames()) {
                if (ROOT_KEYS.contains(key)) continue;
                String value = dataSetDef.getProperty(key);
                json.put(key, value);
            }
        }
        return json;
    }

    protected JsonArray toJsonObject(Collection<DataColumnDef> columnList, DataSetDef dataSetDef) throws JsonException {
        JsonArray result = null;
        if (columnList != null && !columnList.isEmpty()) {
            result = Json.createArray();
            int idx = 0;
            for (DataColumnDef column : columnList) {
                String id = column.getId();
                ColumnType type = column.getColumnType();
                JsonObject columnObject = Json.createObject();
                columnObject.put(COLUMN_ID, id);
                columnObject.put(COLUMN_TYPE, type.name().toLowerCase());
                String pattern = dataSetDef.getPattern(id);
                if (pattern != null && pattern.trim().length() > 0) {
                    columnObject.put(COLUMN_PATTERN, pattern);
                }
                result.set(idx++, (JsonValue)columnObject);
            }
        }
        return result;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

