/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpEngine;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.engine.Chronometer;
import org.dashbuilder.dataset.engine.DataSetHandler;
import org.dashbuilder.dataset.engine.DataSetRowSet;
import org.dashbuilder.dataset.engine.filter.DataSetFilterAlgorithm;
import org.dashbuilder.dataset.engine.group.IntervalBuilder;
import org.dashbuilder.dataset.engine.group.IntervalBuilderLocator;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.engine.index.DataSetFilterIndex;
import org.dashbuilder.dataset.engine.index.DataSetGroupIndex;
import org.dashbuilder.dataset.engine.index.DataSetIndex;
import org.dashbuilder.dataset.engine.index.DataSetIndexNode;
import org.dashbuilder.dataset.engine.index.DataSetIntervalIndex;
import org.dashbuilder.dataset.engine.index.DataSetIntervalSetIndex;
import org.dashbuilder.dataset.engine.index.DataSetSortIndex;
import org.dashbuilder.dataset.engine.index.DataSetStaticIndex;
import org.dashbuilder.dataset.engine.index.spi.DataSetIndexRegistry;
import org.dashbuilder.dataset.engine.sort.DataSetSortAlgorithm;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.AggregateFunction;
import org.dashbuilder.dataset.group.AggregateFunctionManager;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;

@ApplicationScoped
public class SharedDataSetOpEngine
implements DataSetOpEngine {
    @Inject
    protected AggregateFunctionManager aggregateFunctionManager;
    @Inject
    protected IntervalBuilderLocator intervalBuilderLocator;
    @Inject
    protected DataSetIndexRegistry indexRegistry;
    @Inject
    protected DataSetSortAlgorithm sortAlgorithm;
    @Inject
    protected DataSetFilterAlgorithm filterAlgorithm;
    @Inject
    protected Chronometer chronometer;

    public AggregateFunctionManager getAggregateFunctionManager() {
        return this.aggregateFunctionManager;
    }

    public IntervalBuilderLocator getIntervalBuilderLocator() {
        return this.intervalBuilderLocator;
    }

    public DataSetIndexRegistry getIndexRegistry() {
        return this.indexRegistry;
    }

    public DataSetSortAlgorithm getSortAlgorithm() {
        return this.sortAlgorithm;
    }

    public DataSetFilterAlgorithm getFilterAlgorithm() {
        return this.filterAlgorithm;
    }

    public DataSet execute(DataSet dataSet, List<DataSetOp> opList) {
        DataSetOpListProcessor processor = new DataSetOpListProcessor();
        DataSetStaticIndex index = new DataSetStaticIndex(dataSet);
        processor.setDataSetIndex(index);
        processor.setOperationList(opList);
        processor.run();
        return processor.getDataSet();
    }

    public DataSet execute(String uuid, List<DataSetOp> opList) {
        DataSetOpListProcessor processor = new DataSetOpListProcessor();
        processor.setDataSetIndex(this.indexRegistry.get(uuid));
        processor.setOperationList(opList);
        processor.run();
        return processor.getDataSet();
    }

    private class DataSetOpListProcessor
    implements Runnable {
        List<DataSetOp> operationList;
        InternalContext context;

        private DataSetOpListProcessor() {
        }

        public void setDataSetIndex(DataSetIndex index) {
            this.context = new InternalContext(index);
        }

        public void setOperationList(List<DataSetOp> opList) {
            this.operationList = new ArrayList<DataSetOp>(opList);
        }

        protected void checkOpList(List<DataSetOp> opList) {
            StringBuilder out = new StringBuilder();
            for (DataSetOp op : opList) {
                if (DataSetOpType.FILTER.equals((Object)op.getType())) {
                    out.append("F");
                }
                if (DataSetOpType.GROUP.equals((Object)op.getType())) {
                    out.append("G");
                }
                if (!DataSetOpType.SORT.equals((Object)op.getType())) continue;
                out.append("S");
            }
            String pattern = out.toString();
            if (!pattern.matches("F*G*S?")) {
                throw new IllegalArgumentException("Invalid operation sequence order. Valid = (0..N) FILTER > (0..N) GROUP > (0..1) SORT");
            }
        }

        public DataSet getDataSet() {
            return this.context.dataSet;
        }

        @Override
        public void run() {
            if (this.context == null) {
                throw new IllegalStateException("Data set missing");
            }
            this.checkOpList(this.operationList);
            boolean group = false;
            boolean sort = false;
            for (int i = 0; i < this.operationList.size(); ++i) {
                DataSetOp op = this.operationList.get(i);
                if (DataSetOpType.GROUP.equals((Object)op.getType())) {
                    if (sort) {
                        throw new IllegalStateException("Sort operations must be applied ALWAYS AFTER GROUP.");
                    }
                    DataSetGroup gOp = (DataSetGroup)op;
                    ColumnGroup columnGroup = gOp.getColumnGroup();
                    if (columnGroup == null) {
                        group = true;
                        this.context.lastOperation = op;
                        continue;
                    }
                    if (!this.group(gOp, this.context)) continue;
                    group = !this.context.getLastGroupOp().isSelect();
                    this.context.lastOperation = op;
                    continue;
                }
                if (DataSetOpType.FILTER.equals((Object)op.getType())) {
                    if (group) {
                        throw new IllegalStateException("Filter operations must be applied ALWAYS BEFORE GROUP.");
                    }
                    if (sort) {
                        throw new IllegalStateException("Sort operations must be applied ALWAYS AFTER FILTER.");
                    }
                    this.filter((DataSetFilter)op, this.context);
                    this.context.lastOperation = op;
                    continue;
                }
                if (DataSetOpType.SORT.equals((Object)op.getType())) {
                    if (sort) {
                        throw new IllegalStateException("Sort can only be executed once.");
                    }
                    if (group) {
                        this.buildDataSet(this.context);
                    }
                    sort = true;
                    this.sort((DataSetSort)op, this.context);
                    this.context.lastOperation = op;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported operation: " + op.getClass().getName());
            }
            this.buildDataSet(this.context);
        }

        protected void checkGroupOp(DataSet dataSet, DataSetGroup op) {
            String id;
            ColumnGroup cg = op.getColumnGroup();
            if (cg != null && dataSet.getColumnById(id = cg.getSourceId()) == null) {
                throw new IllegalArgumentException("Group column specified not found in the data set: " + id);
            }
        }

        protected boolean group(DataSetGroup op, InternalContext context) {
            this.checkGroupOp(context.dataSet, op);
            ColumnGroup columnGroup = op.getColumnGroup();
            if (columnGroup == null) {
                return true;
            }
            DataSetGroup lastGroupOp = context.getLastGroupOp();
            if (lastGroupOp != null && !lastGroupOp.isSelect() && !op.isJoin()) {
                return false;
            }
            DataSetGroupIndex groupIndex = null;
            groupIndex = context.lastGroupIndex == null ? this.singleGroup(op, context) : this.nestedGroup(op, context.lastGroupIndex, context);
            groupIndex = this.selectIntervals(op, groupIndex);
            context.index(op, groupIndex);
            return true;
        }

        protected DataSetGroupIndex singleGroup(DataSetGroup op, InternalContext context) {
            GroupStrategy groupStrategy;
            ColumnGroup columnGroup = op.getColumnGroup();
            DataColumn sourceColumn = context.dataSet.getColumnById(columnGroup.getSourceId());
            ColumnType columnType = sourceColumn.getColumnType();
            IntervalBuilder intervalBuilder = SharedDataSetOpEngine.this.intervalBuilderLocator.lookup(columnType, groupStrategy = columnGroup.getStrategy());
            if (intervalBuilder == null) {
                throw new RuntimeException("Interval generator not supported.");
            }
            if (context.index == null) {
                IntervalList intervalList = intervalBuilder.build(new InternalHandler(context), columnGroup);
                return new DataSetGroupIndex(columnGroup, intervalList);
            }
            DataSetGroupIndex groupIndex = context.index.getGroupIndex(columnGroup);
            if (groupIndex != null) {
                return groupIndex;
            }
            SharedDataSetOpEngine.this.chronometer.start();
            IntervalList intervalList = intervalBuilder.build(new InternalHandler(context), columnGroup);
            SharedDataSetOpEngine.this.chronometer.stop();
            DataSetGroupIndex index = new DataSetGroupIndex(columnGroup, intervalList);
            index.setBuildTime(SharedDataSetOpEngine.this.chronometer.elapsedTime());
            return context.index.indexGroup(index);
        }

        protected DataSetGroupIndex nestedGroup(DataSetGroup op, DataSetGroupIndex lastGroupIndex, InternalContext context) {
            DataSetGroupIndex nestedGroupIndex = lastGroupIndex.getGroupIndex(op.getColumnGroup());
            if (nestedGroupIndex != null) {
                return nestedGroupIndex;
            }
            nestedGroupIndex = new DataSetGroupIndex(op.getColumnGroup());
            InternalContext nestedContext = new InternalContext(context.dataSet, null);
            List<DataSetIntervalIndex> intervalsIdxs = lastGroupIndex.getIntervalIndexes();
            for (DataSetIntervalIndex intervalIndex : intervalsIdxs) {
                if (intervalIndex instanceof DataSetIntervalSetIndex) {
                    DataSetIntervalSetIndex indexSet = (DataSetIntervalSetIndex)intervalIndex;
                    for (DataSetIntervalIndex subIndex : indexSet.getIntervalIndexes()) {
                        nestedContext.index = subIndex;
                        DataSetGroupIndex sg = this.singleGroup(op, nestedContext);
                        nestedGroupIndex.indexIntervals(sg.getIntervalIndexes());
                    }
                    continue;
                }
                nestedContext.index = intervalIndex;
                DataSetGroupIndex sg = this.singleGroup(op, nestedContext);
                nestedGroupIndex.indexIntervals(sg.getIntervalIndexes());
            }
            context.index.indexGroup(nestedGroupIndex);
            return nestedGroupIndex;
        }

        protected DataSetGroupIndex selectIntervals(DataSetGroup groupOp, DataSetGroupIndex groupIndex) {
            List intervalList = groupOp.getSelectedIntervalList();
            if (intervalList != null && !intervalList.isEmpty()) {
                DataSetGroupIndex selectionIndex = groupIndex.getSelectionIndex(intervalList);
                if (selectionIndex != null) {
                    return selectionIndex;
                }
                List<DataSetIntervalIndex> intervalIdxs = groupIndex.getIntervalIndexes(intervalList);
                if (intervalIdxs.isEmpty()) {
                    intervalIdxs = new ArrayList<DataSetIntervalIndex>();
                    for (Interval interval : intervalList) {
                        intervalIdxs.add(new DataSetIntervalIndex(groupIndex, interval));
                    }
                }
                return groupIndex.indexSelection(intervalList, intervalIdxs);
            }
            return groupIndex;
        }

        protected void checkFilterOp(DataSet dataSet, DataSetFilter op) {
            for (ColumnFilter columnFilter : op.getColumnFilterList()) {
                String id = columnFilter.getColumnId();
                if (dataSet.getColumnById(id) != null) continue;
                throw new IllegalArgumentException("Filter column specified not found in the data set: " + id);
            }
        }

        protected void filter(DataSetFilter op, InternalContext context) {
            this.checkFilterOp(context.dataSet, op);
            if (context.dataSet.getRowCount() == 0) {
                return;
            }
            for (ColumnFilter filter : op.getColumnFilterList()) {
                if (context.index == null) {
                    List<Integer> rows = SharedDataSetOpEngine.this.filterAlgorithm.filter(new InternalHandler(context), filter);
                    context.index(op, new DataSetFilterIndex(filter, rows));
                    continue;
                }
                DataSetFilterIndex index = context.index.getFilterIndex(filter);
                if (index != null) {
                    context.index(op, index);
                    continue;
                }
                SharedDataSetOpEngine.this.chronometer.start();
                List<Integer> rows = SharedDataSetOpEngine.this.filterAlgorithm.filter(new InternalHandler(context), filter);
                SharedDataSetOpEngine.this.chronometer.stop();
                context.index(op, context.index.indexFilter(filter, rows, SharedDataSetOpEngine.this.chronometer.elapsedTime()));
            }
        }

        protected void checkSortOp(DataSet dataSet, DataSetSort op) {
            for (ColumnSort columnSort : op.getColumnSortList()) {
                String id = columnSort.getColumnId();
                if (dataSet.getColumnById(id) != null) continue;
                throw new IllegalArgumentException("Sort column not found in the data set: " + id);
            }
        }

        protected void sort(DataSetSort op, InternalContext context) {
            this.checkSortOp(context.dataSet, op);
            if (context.index == null) {
                List<Integer> orderedRows = SharedDataSetOpEngine.this.sortAlgorithm.sort(context.getDataSet(), context.getRows(), op.getColumnSortList());
                context.index(op, new DataSetSortIndex(op, orderedRows));
                return;
            }
            DataSetSortIndex sortIndex = context.index.getSortIndex(op);
            if (sortIndex != null) {
                context.index(op, sortIndex);
                return;
            }
            SharedDataSetOpEngine.this.chronometer.start();
            List<Integer> orderedRows = SharedDataSetOpEngine.this.sortAlgorithm.sort(context.getDataSet(), context.getRows(), op.getColumnSortList());
            SharedDataSetOpEngine.this.chronometer.stop();
            context.index(op, context.index.indexSort(op, orderedRows, SharedDataSetOpEngine.this.chronometer.elapsedTime()));
        }

        public DataSet buildDataSet(InternalContext context) {
            DataSet result;
            if (context.index == null) {
                return context.dataSet;
            }
            context.dataSet = result = this._buildDataSet(context);
            context.index = null;
            return result;
        }

        private DataSet _buildDataSet(InternalContext context) {
            DataSetOp lastOp = context.lastOperation;
            DataSetIndexNode index = context.index;
            DataSet dataSet = context.dataSet;
            if (lastOp instanceof DataSetGroup) {
                DataSetGroup gOp = (DataSetGroup)lastOp;
                ColumnGroup columnGroup = gOp.getColumnGroup();
                if (columnGroup == null) {
                    boolean hasAggregations = !gOp.getAggregationFunctions().isEmpty();
                    return this._buildDataSet(context, gOp.getGroupFunctions(), hasAggregations);
                }
                if (gOp.isSelect() && gOp.getGroupFunctions().isEmpty()) {
                    return dataSet.trim(index.getRows());
                }
                return this._buildDataSet(context, gOp);
            }
            if (lastOp instanceof DataSetFilter) {
                return dataSet.trim(index.getRows());
            }
            if (lastOp instanceof DataSetSort) {
                return DataSetFactory.filterDataSet((DataSet)dataSet, index.getRows());
            }
            return dataSet;
        }

        private DataSet _buildDataSet(InternalContext context, DataSetGroup op) {
            DataSetGroupIndex index = context.lastGroupIndex;
            DataSet dataSet = context.dataSet;
            ColumnGroup columnGroup = op.getColumnGroup();
            List groupFunctions = op.getGroupFunctions();
            DataSet result = DataSetFactory.newEmptyDataSet();
            for (GroupFunction gf : op.getGroupFunctions()) {
                String sourceId = gf.getSourceId();
                String columnId = gf.getColumnId() == null ? sourceId : gf.getColumnId();
                AggregateFunctionType columnFunction = gf.getFunction();
                if (sourceId != null && sourceId.equals(columnGroup.getSourceId()) && columnFunction == null) {
                    DataColumnImpl column = new DataColumnImpl(columnId, ColumnType.LABEL);
                    column.setColumnGroup(columnGroup);
                    column.setIntervalType(index.getIntervalType());
                    column.setMinValue(index.getMinValue());
                    column.setMaxValue(index.getMaxValue());
                    column.setGroupFunction(gf);
                    result.addColumn((DataColumn)column);
                    continue;
                }
                AggregateFunctionType aggF = gf.getFunction();
                if (aggF != null) {
                    DataColumnImpl column = new DataColumnImpl(columnId, ColumnType.NUMBER);
                    column.setGroupFunction(gf);
                    result.addColumn((DataColumn)column);
                    continue;
                }
                DataColumn targetColumn = dataSet.getColumnById(sourceId);
                if (targetColumn == null) {
                    throw new IllegalArgumentException("Column not found: " + columnId);
                }
                DataColumnImpl column = new DataColumnImpl(columnId, targetColumn.getColumnType());
                column.setGroupFunction(gf);
                result.addColumn((DataColumn)column);
            }
            List<DataSetIntervalIndex> intervalIdxs = index.getIntervalIndexes();
            int row = 0;
            for (int i = 0; i < intervalIdxs.size(); ++i) {
                DataSetIntervalIndex intervalIdx = intervalIdxs.get(i);
                if (intervalIdx.getRows().isEmpty() && !columnGroup.areEmptyIntervalsAllowed()) continue;
                for (int j = 0; j < groupFunctions.size(); ++j) {
                    GroupFunction groupFunction = (GroupFunction)groupFunctions.get(j);
                    String sourceId = groupFunction.getSourceId();
                    AggregateFunctionType columnFunction = groupFunction.getFunction();
                    if (sourceId != null && sourceId.equals(columnGroup.getSourceId()) && columnFunction == null) {
                        result.setValueAt(row, j, (Object)intervalIdx.getName());
                        continue;
                    }
                    DataColumn dataColumn = dataSet.getColumnByIndex(0);
                    if (sourceId != null) {
                        dataColumn = dataSet.getColumnById(sourceId);
                    }
                    if (columnFunction != null) {
                        Double aggValue = this._calculateFunction(dataColumn, groupFunction.getFunction(), intervalIdx);
                        result.setValueAt(row, j, (Object)aggValue);
                        continue;
                    }
                    List<Integer> rows = intervalIdx.getRows();
                    if (rows == null || rows.isEmpty()) {
                        result.setValueAt(row, j, null);
                        continue;
                    }
                    int intervalRow = rows.get(0);
                    Object firstValue = dataColumn.getValues().get(intervalRow);
                    result.setValueAt(row, j, firstValue);
                }
                ++row;
            }
            return result;
        }

        private DataSet _buildDataSet(InternalContext context, List<GroupFunction> groupFunctions, boolean hasAggregations) {
            DataSetIndexNode index = context.index;
            DataSet dataSet = context.dataSet;
            DataSet result = DataSetFactory.newEmptyDataSet();
            if (hasAggregations) {
                for (int i = 0; i < groupFunctions.size(); ++i) {
                    GroupFunction gf = groupFunctions.get(i);
                    String sourceId = gf.getSourceId();
                    String columnId = gf.getColumnId() == null ? sourceId : gf.getColumnId();
                    DataColumnImpl column = new DataColumnImpl(columnId, ColumnType.NUMBER);
                    column.setGroupFunction(gf);
                    result.addColumn((DataColumn)column);
                    DataColumn dataColumn = dataSet.getColumnById(sourceId);
                    if (dataColumn == null) {
                        dataColumn = dataSet.getColumnByIndex(0);
                    }
                    Double aggValue = this._calculateFunction(dataColumn, gf.getFunction(), index);
                    result.setValueAt(0, i, (Object)aggValue);
                }
            } else {
                DataSet _temp = dataSet.trim(index.getRows());
                for (int i = 0; i < groupFunctions.size(); ++i) {
                    GroupFunction gf = groupFunctions.get(i);
                    String sourceId = gf.getSourceId();
                    String columnId = gf.getColumnId() == null ? sourceId : gf.getColumnId();
                    DataColumn targetColumn = _temp.getColumnById(sourceId);
                    DataColumnImpl column = new DataColumnImpl(columnId, targetColumn.getColumnType());
                    column.setGroupFunction(gf);
                    column.setValues(targetColumn.getValues());
                    result.addColumn((DataColumn)column);
                }
            }
            return result;
        }

        private Double _calculateFunction(DataColumn column, AggregateFunctionType type, DataSetIndexNode index) {
            Double sv;
            if (type == null) {
                throw new IllegalArgumentException("No aggregation function specified for the column: " + column.getId());
            }
            if (index != null && (sv = index.getAggValue(column.getId(), type)) != null) {
                return sv;
            }
            SharedDataSetOpEngine.this.chronometer.start();
            AggregateFunction function = SharedDataSetOpEngine.this.aggregateFunctionManager.getFunctionByType(type);
            double aggValue = function.aggregate(column.getValues(), index.getRows());
            SharedDataSetOpEngine.this.chronometer.stop();
            if (index != null) {
                index.indexAggValue(column.getId(), type, aggValue, SharedDataSetOpEngine.this.chronometer.elapsedTime());
            }
            return aggValue;
        }

        class InternalHandler
        extends InternalContext
        implements DataSetHandler {
            InternalHandler(InternalContext context) {
                super(context.dataSet, context.index);
            }

            @Override
            public DataSetHandler group(DataSetGroup op) {
                DataSetOpListProcessor.this.group(op, this);
                return this;
            }

            @Override
            public DataSetHandler filter(DataSetFilter op) {
                DataSetOpListProcessor.this.filter(op, this);
                return this;
            }

            @Override
            public DataSetHandler sort(DataSetSort op) {
                DataSetOpListProcessor.this.sort(op, this);
                return this;
            }
        }

        class InternalContext
        implements DataSetRowSet {
            DataSet dataSet = null;
            DataSetIndexNode index = null;
            DataSetOp lastOperation = null;
            List<DataSetGroup> groupOpList = new ArrayList<DataSetGroup>();
            DataSetGroupIndex lastGroupIndex = null;
            DataSetFilter lastFilterOp = null;
            DataSetFilterIndex lastFilterIndex = null;
            DataSetSort lastSortOp = null;
            DataSetSortIndex lastSortIndex = null;

            InternalContext(DataSetIndex index) {
                this(index.getDataSet(), index);
            }

            InternalContext(DataSet dataSet, DataSetIndexNode index) {
                this.dataSet = dataSet;
                this.index = index;
            }

            @Override
            public DataSet getDataSet() {
                return this.dataSet;
            }

            @Override
            public List<Integer> getRows() {
                if (this.index == null) {
                    return null;
                }
                return this.index.getRows();
            }

            public void index(DataSetGroup op, DataSetGroupIndex gi) {
                this.lastGroupIndex = gi;
                this.index = this.lastGroupIndex;
                this.lastOperation = op;
                this.groupOpList.add(op);
            }

            public void index(DataSetFilter op, DataSetFilterIndex i) {
                this.lastFilterIndex = i;
                this.index = this.lastFilterIndex;
                this.lastFilterOp = op;
                this.lastOperation = this.lastFilterOp;
            }

            public void index(DataSetSort op, DataSetSortIndex i) {
                this.lastSortIndex = i;
                this.index = this.lastSortIndex;
                this.lastSortOp = op;
                this.lastOperation = this.lastSortOp;
            }

            public DataSetGroup getLastGroupOp() {
                if (this.groupOpList.isEmpty()) {
                    return null;
                }
                return this.groupOpList.get(this.groupOpList.size() - 1);
            }
        }
    }
}

