/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.filter;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.engine.filter.DataSetFilterContext;
import org.dashbuilder.dataset.engine.filter.DataSetFunction;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;

public class LogicalFunction
extends DataSetFunction {
    private LogicalExprFilter logicalFunctionFilter;
    private List<DataSetFunction> functionTerms = new ArrayList<DataSetFunction>();

    public LogicalFunction(DataSetFilterContext ctx, LogicalExprFilter filter) {
        super(ctx, (ColumnFilter)filter);
        this.logicalFunctionFilter = filter;
    }

    public LogicalFunction addFunctionTerm(DataSetFunction functionTerm) {
        this.functionTerms.add(functionTerm);
        return this;
    }

    @Override
    public boolean pass() {
        LogicalExprType type = this.logicalFunctionFilter.getLogicalOperator();
        if (LogicalExprType.NOT.equals((Object)type)) {
            for (DataSetFunction term : this.functionTerms) {
                boolean termOk = term.pass();
                if (!termOk) continue;
                return false;
            }
            return true;
        }
        if (LogicalExprType.AND.equals((Object)type)) {
            for (DataSetFunction term : this.functionTerms) {
                boolean termOk = term.pass();
                if (termOk) continue;
                return false;
            }
            return true;
        }
        if (LogicalExprType.OR.equals((Object)type)) {
            for (DataSetFunction term : this.functionTerms) {
                boolean termOk = term.pass();
                if (!termOk) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Logical operator not supported: " + type);
    }
}

