/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.function;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.dataset.engine.function.AverageFunction;
import org.dashbuilder.dataset.engine.function.CountFunction;
import org.dashbuilder.dataset.engine.function.DistinctFunction;
import org.dashbuilder.dataset.engine.function.MaxFunction;
import org.dashbuilder.dataset.engine.function.MinFunction;
import org.dashbuilder.dataset.engine.function.SumFunction;
import org.dashbuilder.dataset.group.AggregateFunction;
import org.dashbuilder.dataset.group.AggregateFunctionManager;
import org.dashbuilder.dataset.group.AggregateFunctionType;

@ApplicationScoped
public class AggregateFunctionManagerImpl
implements AggregateFunctionManager {
    protected Map<AggregateFunctionType, AggregateFunction> functionMap = new EnumMap<AggregateFunctionType, AggregateFunction>(AggregateFunctionType.class);

    @PostConstruct
    protected void init() {
        this.registerFunction(new CountFunction());
        this.registerFunction(new DistinctFunction());
        this.registerFunction(new SumFunction());
        this.registerFunction(new AverageFunction());
        this.registerFunction(new MaxFunction());
        this.registerFunction(new MinFunction());
    }

    public Collection<AggregateFunction> getAllFunctions() {
        return this.functionMap.values();
    }

    public AggregateFunction getFunctionByType(AggregateFunctionType type) {
        return this.functionMap.get(type);
    }

    public void registerFunction(AggregateFunction function) {
        this.functionMap.put(function.getType(), function);
    }
}

