/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.group;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.Interval;

public class IntervalListDayOfWeek
extends IntervalList {
    protected Map<Integer, Interval> intervalMap = new HashMap<Integer, Interval>();

    public IntervalListDayOfWeek(ColumnGroup columnGroup) {
        super(columnGroup);
        DayOfWeek firstDay = columnGroup.getFirstDayOfWeek();
        int index = firstDay.getIndex();
        DayOfWeek[] array = DayOfWeek.getAll();
        for (int i = 0; i < array.length; ++i) {
            DayOfWeek dayOfWeek = array[index - 1];
            Interval interval = new Interval(Integer.toString(dayOfWeek.getIndex()), i);
            this.add(interval);
            this.intervalMap.put(index - 1, interval);
            index = DayOfWeek.nextIndex((int)index);
        }
    }

    @Override
    public Interval locateInterval(Object value) {
        Date d = (Date)value;
        return this.intervalMap.get(d.getDay());
    }
}

