/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavTreeChangedEvent;
import org.dashbuilder.client.navigation.widget.NavWidget;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveRoleEvent;
import org.uberfire.mvp.Command;

public abstract class BaseNavWidget
implements NavWidget {
    NavigationManager navigationManager;
    boolean secure = true;
    boolean hideEmptyGroups = true;
    Command onItemSelectedCommand;
    Command onStaleCommand;
    NavItem itemSelected;
    NavGroup navGroup;
    NavWidget parent;
    NavWidgetView view;
    int maxLevels = -1;
    List<NavItem> navItemList = null;
    NavWidget activeNavSubgroup = null;
    List<NavWidget> navSubgroupList = new ArrayList<NavWidget>();

    @Inject
    public BaseNavWidget(NavWidgetView view, NavigationManager navigationManager) {
        this.view = view;
        this.navigationManager = navigationManager;
        view.init(this);
    }

    public NavigationManager getNavigationManager() {
        return this.navigationManager;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public void setHideEmptyGroups(boolean hide) {
        this.hideEmptyGroups = hide;
    }

    @Override
    public void setOnItemSelectedCommand(Command onItemSelected) {
        this.onItemSelectedCommand = onItemSelected;
    }

    @Override
    public void setOnStaleCommand(Command onStaleCommand) {
        this.onStaleCommand = onStaleCommand;
    }

    public NavItem getItem(String id) {
        for (NavItem navItem : this.navItemList) {
            if (!navItem.getId().equals(id)) continue;
            return navItem;
        }
        return null;
    }

    @Override
    public int getLevel() {
        int level = 0;
        for (NavWidget root = this.parent; root != null; root = root.getParent()) {
            ++level;
        }
        return level;
    }

    @Override
    public NavWidget getParent() {
        return this.parent;
    }

    @Override
    public void setParent(NavWidget parent) {
        this.parent = parent;
    }

    @Override
    public int getMaxLevels() {
        return this.maxLevels;
    }

    @Override
    public void setMaxLevels(int maxLevels) {
        this.maxLevels = maxLevels;
    }

    @Override
    public NavGroup getNavGroup() {
        return this.navGroup;
    }

    public boolean areSubGroupsSupported() {
        return this.maxLevels < 1 || this.getLevel() < this.maxLevels;
    }

    protected NavWidget lookupNavGroupWidget() {
        return null;
    }

    @Override
    public void show(NavGroup navGroup) {
        this.navGroup = navGroup;
        this.show(navGroup.getChildren());
    }

    @Override
    public void show(NavTree navTree) {
        this.show(navTree.getRootItems());
    }

    @Override
    public void show(List<NavItem> itemList) {
        this.navItemList = itemList;
        this.navSubgroupList.clear();
        if (this.secure) {
            this.navItemList = new ArrayList<NavItem>(itemList);
            this.navigationManager.secure(this.navItemList, this.hideEmptyGroups);
        }
        this.view.clearItems();
        if (this.navItemList.isEmpty()) {
            this.view.errorNavItemsEmpty();
        }
        for (NavItem navChild : this.navItemList) {
            if (navChild instanceof NavGroup) {
                if (!this.areSubGroupsSupported()) continue;
                this.showGroup((NavGroup)navChild);
                continue;
            }
            if (navChild instanceof NavDivider) {
                this.view.addDivider();
                continue;
            }
            this.showItem(navChild);
        }
    }

    protected void showGroup(NavGroup navGroup) {
        NavWidget subGroupNavWidget = this.lookupNavGroupWidget();
        if (subGroupNavWidget != null) {
            subGroupNavWidget.setParent(this);
            subGroupNavWidget.setMaxLevels(this.maxLevels > 0 ? this.maxLevels - 1 : -1);
            subGroupNavWidget.setSecure(this.secure);
            subGroupNavWidget.setHideEmptyGroups(this.hideEmptyGroups);
            subGroupNavWidget.setOnItemSelectedCommand(() -> this.onSubGroupItemClicked(subGroupNavWidget));
            subGroupNavWidget.show(navGroup);
            this.navSubgroupList.add(subGroupNavWidget);
            this.view.addGroupItem(navGroup.getId(), navGroup.getName(), navGroup.getDescription(), subGroupNavWidget);
        }
    }

    protected void showItem(NavItem navItem) {
        this.view.addItem(navItem.getId(), navItem.getName(), navItem.getDescription(), () -> this.onItemClicked(navItem));
    }

    @Override
    public NavItem getItemSelected() {
        return this.itemSelected;
    }

    @Override
    public void setSelectedItem(String id) {
        this.itemSelected = this.getItem(id);
        this.view.setSelectedItem(id);
        this.navSubgroupList.stream().filter(w -> w.getNavGroup() != null && w.getNavGroup().getId().equals(id)).forEach(w -> w.setActive(true));
    }

    @Override
    public void clearSelectedItem() {
        this.itemSelected = null;
        this.view.clearSelectedItem();
        this.navSubgroupList.forEach(w -> w.setActive(false));
    }

    @Override
    public void setActive(boolean active) {
        this.view.setActive(active);
        if (!active) {
            this.navSubgroupList.forEach(NavWidget::clearSelections);
        }
    }

    @Override
    public void clearSelections() {
        this.view.setActive(false);
        this.view.clearSelectedItem();
    }

    public void onSubGroupItemClicked(NavWidget subGroup) {
        if (this.activeNavSubgroup != null && this.activeNavSubgroup != subGroup) {
            this.activeNavSubgroup.setActive(false);
            this.activeNavSubgroup.clearSelections();
        }
        this.activeNavSubgroup = subGroup;
        subGroup.setActive(true);
        this.view.clearSelectedItem();
        this.itemSelected = subGroup.getItemSelected();
        if (this.onItemSelectedCommand != null) {
            this.onItemSelectedCommand.execute();
        }
    }

    public void onItemClicked(NavItem navItem) {
        if (this.activeNavSubgroup != null) {
            this.activeNavSubgroup.setActive(false);
            this.activeNavSubgroup.clearSelections();
            this.activeNavSubgroup = null;
        }
        this.itemSelected = navItem;
        this.view.setSelectedItem(navItem.getId());
        this.navigationManager.navItemClicked(navItem);
        if (this.onItemSelectedCommand != null) {
            this.onItemSelectedCommand.execute();
        }
    }

    protected void refresh() {
        if (this.onStaleCommand != null) {
            this.onStaleCommand.execute();
        }
    }

    public void onNavTreeChanged(@Observes NavTreeChangedEvent event) {
        this.refresh();
    }

    public void onAuthzPolicyChanged(@Observes SaveRoleEvent event) {
        if (this.secure) {
            this.refresh();
        }
    }

    public void onAuthzPolicyChanged(@Observes SaveGroupEvent event) {
        if (this.secure) {
            this.refresh();
        }
    }
}

