/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Node;
import org.uberfire.mvp.Command;

public abstract class BaseNavWidgetView<T>
extends Composite
implements NavWidgetView<T> {
    protected Node navWidget = null;
    protected com.google.gwt.dom.client.Element selectedItem = null;
    protected Map<String, com.google.gwt.dom.client.Element> itemMap = new HashMap<String, com.google.gwt.dom.client.Element>();

    @Override
    public void clearItems() {
        DOMUtil.removeAllChildren((Node)this.navWidget);
    }

    @Override
    public void addGroupItem(String id, String name, String description, IsWidget widget) {
        Element el = widget.asWidget().getElement();
        this.navWidget.appendChild((Node)el);
    }

    @Override
    public void addItem(String id, String name, String description, Command onItemSelected) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setInnerText(name);
        if (description != null && !description.equals(name)) {
            anchor.setTitle(description);
        }
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((com.google.gwt.dom.client.Node)anchor);
        this.navWidget.appendChild((Node)li);
        this.itemMap.put(id, (com.google.gwt.dom.client.Element)li);
        Event.sinkEvents((com.google.gwt.dom.client.Element)anchor, (int)1);
        Event.setEventListener((com.google.gwt.dom.client.Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                onItemSelected.execute();
            }
        });
    }

    @Override
    public void setSelectedItem(String id) {
        com.google.gwt.dom.client.Element el = this.itemMap.get(id);
        if (el != null) {
            this.clearSelectedItem();
            this.selectedItem = el;
            el.setClassName("active");
        }
    }

    @Override
    public void clearSelectedItem() {
        if (this.selectedItem != null) {
            this.selectedItem.setClassName("");
        }
    }

    @Override
    public void errorNavItemNotFound(String navItemId) {
        this.addItem(navItemId, NavigationConstants.INSTANCE.navItemNotFound(navItemId), null, () -> {});
    }

    @Override
    public void errorNavItemsEmpty() {
        this.addItem("error", NavigationConstants.INSTANCE.navItemsEmpty(), null, () -> {});
    }

    public com.google.gwt.dom.client.Element createErrorWidget(String message) {
        Element div = DOM.createDiv();
        Element span1 = DOM.createSpan();
        Element span2 = DOM.createSpan();
        div.setClassName("alert alert-warning");
        div.getStyle().setWidth(30.0, Style.Unit.PCT);
        div.getStyle().setMargin(10.0, Style.Unit.PX);
        span1.setClassName("pficon pficon-warning-triangle-o");
        span2.setInnerText(message);
        div.appendChild((com.google.gwt.dom.client.Node)span1);
        div.appendChild((com.google.gwt.dom.client.Node)span2);
        return div;
    }
}

