/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveNameProvider;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.ActivityResourceType;

@Dependent
public class NavItemEditor
implements IsWidget {
    View view;
    PlaceManager placeManager;
    PerspectiveDropDown perspectiveDropDown;
    PerspectivePluginManager perspectivePluginManager;
    boolean newDividerEnabled = true;
    boolean newGroupEnabled = true;
    boolean newPerspectiveEnabled = true;
    boolean creationEnabled = false;
    boolean moveUpEnabled = true;
    boolean moveDownEnabled = true;
    boolean gotoPerspectiveEnabled = false;
    boolean editEnabled = false;
    boolean deleteEnabled = false;
    Set<String> visiblePerspectiveIds = null;
    Set<String> hiddenPerspectiveIds = null;
    PerspectiveNameProvider perspectiveNameProvider = null;
    NavItem navItem = null;
    String perspectiveId = null;
    Command onUpdateCommand;
    Command onErrorCommand;
    Command onMoveUpCommand;
    Command onMoveDownCommand;
    Command onMoveFirstCommand;
    Command onMoveLastCommand;
    Command onDeleteCommand;
    Command onNewSubgroupCommand;
    Command onNewPerspectiveCommand;
    Command onNewDividerCommand;
    Command onEditStartedCommand;
    String literalGroup = "Group";
    String literalPerspective = "Perspective";
    String literalDivider = "Divider";
    String dividerName = "--------------";

    @Inject
    public NavItemEditor(View view, PlaceManager placeManager, PerspectiveDropDown perspectiveDropDown, PerspectivePluginManager perspectivePluginManager) {
        this.view = view;
        this.placeManager = placeManager;
        this.perspectiveDropDown = perspectiveDropDown;
        this.perspectivePluginManager = perspectivePluginManager;
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public boolean isNewGroupEnabled() {
        return this.newGroupEnabled;
    }

    public void setNewGroupEnabled(boolean newGroupEnabled) {
        this.newGroupEnabled = newGroupEnabled;
    }

    public boolean isNewDividerEnabled() {
        return this.newDividerEnabled;
    }

    public void setNewDividerEnabled(boolean newDividerEnabled) {
        this.newDividerEnabled = newDividerEnabled;
    }

    public boolean isNewPerspectiveEnabled() {
        return this.newPerspectiveEnabled;
    }

    public void setNewPerspectiveEnabled(boolean newPerspectiveEnabled) {
        this.newPerspectiveEnabled = newPerspectiveEnabled;
    }

    public boolean isMoveUpEnabled() {
        return this.moveUpEnabled;
    }

    public void setMoveUpEnabled(boolean moveUpEnabled) {
        this.moveUpEnabled = moveUpEnabled;
    }

    public boolean isMoveDownEnabled() {
        return this.moveDownEnabled;
    }

    public void setMoveDownEnabled(boolean moveDownEnabled) {
        this.moveDownEnabled = moveDownEnabled;
    }

    public boolean isGotoPerspectiveEnabled() {
        return this.gotoPerspectiveEnabled;
    }

    public void setGotoPerspectiveEnabled(boolean gotoPerspectiveEnabled) {
        this.gotoPerspectiveEnabled = gotoPerspectiveEnabled;
    }

    public void setOnUpdateCommand(Command onUpdateCommand) {
        this.onUpdateCommand = onUpdateCommand;
    }

    public void setOnErrorCommand(Command onErrorCommand) {
        this.onErrorCommand = onErrorCommand;
    }

    public void setOnMoveFirstCommand(Command onMoveFirstCommand) {
        this.onMoveFirstCommand = onMoveFirstCommand;
    }

    public void setOnMoveLastCommand(Command onMoveLastCommand) {
        this.onMoveLastCommand = onMoveLastCommand;
    }

    public void setOnMoveUpCommand(Command onMoveUpCommand) {
        this.onMoveUpCommand = onMoveUpCommand;
    }

    public void setOnMoveDownCommand(Command onMoveDownCommand) {
        this.onMoveDownCommand = onMoveDownCommand;
    }

    public void setOnDeleteCommand(Command onDeleteCommand) {
        this.onDeleteCommand = onDeleteCommand;
    }

    public void setOnNewSubgroupCommand(Command onNewSubgroupCommand) {
        this.onNewSubgroupCommand = onNewSubgroupCommand;
    }

    public void setOnNewPerspectiveCommand(Command onNewPerspectiveCommand) {
        this.onNewPerspectiveCommand = onNewPerspectiveCommand;
    }

    public void setOnNewDividerCommand(Command onNewDividerCommand) {
        this.onNewDividerCommand = onNewDividerCommand;
    }

    public void setOnEditStartedCommand(Command onEditStartedCommand) {
        this.onEditStartedCommand = onEditStartedCommand;
    }

    public NavItem getNavItem() {
        return this.navItem;
    }

    public void setLiteralGroup(String literalGroup) {
        this.literalGroup = literalGroup;
    }

    public void setLiteralPerspective(String literalPerspective) {
        this.literalPerspective = literalPerspective;
    }

    public void setLiteralDivider(String literalDivider) {
        this.literalDivider = literalDivider;
    }

    public void setVisiblePerspectiveIds(Set<String> visiblePerspectiveIds) {
        this.visiblePerspectiveIds = visiblePerspectiveIds;
    }

    public void setHiddenPerspectiveIds(Set<String> hiddenPerspectiveIds) {
        this.hiddenPerspectiveIds = hiddenPerspectiveIds;
    }

    public void setPerspectiveNameProvider(PerspectiveNameProvider perspectiveNameProvider) {
        this.perspectiveNameProvider = perspectiveNameProvider;
    }

    public void edit(NavItem navItem) {
        this.navItem = navItem.cloneItem();
        NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)navItem);
        if (navItem.getName() != null) {
            this.view.setItemName(navItem.getName());
        } else {
            this.view.setItemName(this.dividerName);
        }
        if (navItem.getDescription() != null) {
            this.view.setItemDescription(navItem.getDescription());
        }
        this.creationEnabled = false;
        this.editEnabled = navItem.isModifiable();
        this.deleteEnabled = navItem.isModifiable();
        if (navItem instanceof NavGroup) {
            this.view.setItemType(ItemType.GROUP);
            this.creationEnabled = true;
        } else if (navItem instanceof NavDivider) {
            this.view.setItemType(ItemType.DIVIDER);
            this.editEnabled = false;
        } else if (navCtx.getResourceId() != null && ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) {
            if (this.visiblePerspectiveIds == null || this.visiblePerspectiveIds.contains(navCtx.getResourceId())) {
                this.perspectiveId = navCtx.getResourceId();
            } else {
                this.perspectiveId = this.visiblePerspectiveIds.iterator().next();
                navCtx.setResourceId(this.perspectiveId);
                navItem.setContext(navCtx.toString());
            }
            if (this.hiddenPerspectiveIds != null) {
                this.perspectiveDropDown.setPerspectiveIdsExcluded(this.hiddenPerspectiveIds);
            }
            if (this.perspectiveNameProvider != null) {
                this.perspectiveDropDown.setPerspectiveNameProvider(this.perspectiveNameProvider);
            }
            this.perspectiveDropDown.setMaxItems(50);
            this.perspectiveDropDown.setOnChange(this::onPerspectiveChanged);
            this.perspectiveDropDown.setSelectedPerspective(this.perspectiveId);
            this.view.setItemType(this.perspectivePluginManager.isRuntimePerspective(this.perspectiveId) ? ItemType.RUNTIME_PERSPECTIVE : ItemType.PERSPECTIVE);
            this.view.setContextWidget((IsWidget)this.perspectiveDropDown);
        }
        this.view.setItemEditable(this.editEnabled);
        this.addCommands();
    }

    private void addCommands() {
        boolean dividerRequired = false;
        if (this.creationEnabled) {
            if (this.newGroupEnabled) {
                this.addCommand(this.view.i18nNewItem(this.literalGroup), this::onNewSubGroup);
                dividerRequired = true;
            }
            if (this.newDividerEnabled) {
                this.addCommand(this.view.i18nNewItem(this.literalDivider), this::onNewDivider);
                dividerRequired = true;
            }
            if (this.newPerspectiveEnabled) {
                this.addCommand(this.view.i18nNewItem(this.literalPerspective), this::onNewPerspective);
                dividerRequired = true;
            }
        }
        if (this.moveUpEnabled || this.moveDownEnabled) {
            if (dividerRequired) {
                this.view.addCommandDivider();
            }
            dividerRequired = true;
            if (this.moveUpEnabled) {
                this.addCommand(this.view.i18nMoveFirst(), this::onMoveFirstItem);
                this.addCommand(this.view.i18nMoveUp(), this::onMoveUpItem);
            }
            if (this.moveDownEnabled) {
                this.addCommand(this.view.i18nMoveDown(), this::onMoveDownItem);
                this.addCommand(this.view.i18nMoveLast(), this::onMoveLastItem);
            }
        }
        if (this.gotoPerspectiveEnabled && this.perspectiveId != null) {
            if (dividerRequired) {
                this.view.addCommandDivider();
            }
            dividerRequired = true;
            this.addCommand(this.view.i18nGotoItem(this.literalPerspective), this::onGotoPerspective);
        }
        if (this.deleteEnabled) {
            if (dividerRequired) {
                this.view.addCommandDivider();
            }
            dividerRequired = true;
            this.addCommand(this.view.i18nDeleteItem(), this::onDeleteItem);
        }
    }

    private void addCommand(String name, Command action) {
        this.view.addCommand(name, action);
        this.view.setCommandsEnabled(true);
    }

    public void onItemClick() {
        if (this.editEnabled) {
            this.view.startItemEdition();
            this.onEditStarted();
        }
    }

    public void onItemNameChanged(String name) {
        if (name != null && name.length() > 0) {
            this.navItem.setName(name);
            this.view.setItemName(name);
            if (this.onUpdateCommand != null) {
                this.onUpdateCommand.execute();
            }
        } else if (this.onErrorCommand != null) {
            this.onErrorCommand.execute();
        }
    }

    private void onPerspectiveChanged() {
        String perspectiveId = this.perspectiveDropDown.getSelectedPerspective().getIdentifier();
        if (perspectiveId != null && perspectiveId.length() > 0) {
            NavWorkbenchCtx navCtx = NavWorkbenchCtx.perspective((String)perspectiveId);
            this.navItem.setContext(navCtx.toString());
            if (this.onUpdateCommand != null) {
                this.onUpdateCommand.execute();
            }
        } else if (this.onErrorCommand != null) {
            this.onErrorCommand.execute();
        }
    }

    public void onGotoPerspective() {
        this.placeManager.goTo(this.perspectiveId);
    }

    private void onNewSubGroup() {
        if (this.onNewSubgroupCommand != null) {
            this.onNewSubgroupCommand.execute();
        }
    }

    private void onNewPerspective() {
        if (this.onNewPerspectiveCommand != null) {
            this.onNewPerspectiveCommand.execute();
        }
    }

    private void onNewDivider() {
        if (this.onNewDividerCommand != null) {
            this.onNewDividerCommand.execute();
        }
    }

    public void onDeleteItem() {
        if (this.onDeleteCommand != null) {
            this.onDeleteCommand.execute();
        }
    }

    private void onMoveUpItem() {
        if (this.onMoveUpCommand != null) {
            this.onMoveUpCommand.execute();
        }
    }

    private void onMoveDownItem() {
        if (this.onMoveDownCommand != null) {
            this.onMoveDownCommand.execute();
        }
    }

    private void onMoveFirstItem() {
        if (this.onMoveFirstCommand != null) {
            this.onMoveFirstCommand.execute();
        }
    }

    private void onMoveLastItem() {
        if (this.onMoveLastCommand != null) {
            this.onMoveLastCommand.execute();
        }
    }

    public void onEditStarted() {
        if (this.onEditStartedCommand != null) {
            this.onEditStartedCommand.execute();
        }
    }

    public void finishEditing() {
        this.view.finishItemEdition();
    }

    public static interface View
    extends UberView<NavItemEditor> {
        public void setItemName(String var1);

        public void setItemDescription(String var1);

        public void setItemType(ItemType var1);

        public void addCommand(String var1, Command var2);

        public void addCommandDivider();

        public void setCommandsEnabled(boolean var1);

        public void setItemEditable(boolean var1);

        public void startItemEdition();

        public void finishItemEdition();

        public void setContextWidget(IsWidget var1);

        public String i18nNewItem(String var1);

        public String i18nGotoItem(String var1);

        public String i18nDeleteItem();

        public String i18nMoveUp();

        public String i18nMoveDown();

        public String i18nMoveFirst();

        public String i18nMoveLast();
    }

    public static enum ItemType {
        DIVIDER,
        GROUP,
        PERSPECTIVE,
        RUNTIME_PERSPECTIVE;

    }
}

