/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.NavItemEditor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Templated
public class NavItemEditorView
extends Composite
implements NavItemEditor.View {
    @Inject
    @DataField
    Span itemIcon;
    @Inject
    @DataField
    Span itemName;
    @Inject
    @DataField
    Input itemNameInput;
    @Inject
    @DataField
    Div extraDiv;
    @Inject
    @DataField
    UnorderedList commandMenu;
    NavigationConstants i18n = NavigationConstants.INSTANCE;
    NavItemEditor presenter;

    public void init(NavItemEditor presenter) {
        this.presenter = presenter;
        this.itemIcon.setTitle(this.i18n.itemMenuTitle());
        this.itemNameInput.getStyle().setProperty("display", "none");
        this.extraDiv.getStyle().setProperty("display", "none");
    }

    @Override
    public void setItemName(String name) {
        this.itemName.setTextContent(name);
        this.itemNameInput.setValue(name);
    }

    @Override
    public void setItemDescription(String description) {
        this.itemName.setTitle(description);
    }

    @Override
    public void setItemType(NavItemEditor.ItemType type) {
        if (type == NavItemEditor.ItemType.GROUP) {
            this.itemIcon.setClassName("pficon-folder-open");
        } else if (type == NavItemEditor.ItemType.DIVIDER) {
            this.itemIcon.setClassName("fa fa-minus");
        } else if (type == NavItemEditor.ItemType.PERSPECTIVE) {
            this.itemIcon.setClassName("pficon-screen");
        } else if (type == NavItemEditor.ItemType.RUNTIME_PERSPECTIVE) {
            this.itemIcon.setClassName("pficon-virtual-machine");
        }
    }

    @Override
    public void addCommand(String name, Command command) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setInnerText(name);
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((Node)anchor);
        this.commandMenu.appendChild((org.jboss.errai.common.client.dom.Node)li);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                command.execute();
            }
        });
    }

    @Override
    public void addCommandDivider() {
        LIElement li = Document.get().createLIElement();
        li.setClassName("divider");
        this.commandMenu.appendChild((org.jboss.errai.common.client.dom.Node)li);
    }

    @Override
    public void setCommandsEnabled(boolean enabled) {
        if (enabled) {
            this.commandMenu.getStyle().removeProperty("display");
        } else {
            this.commandMenu.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void startItemEdition() {
        this.itemName.getStyle().setProperty("display", "none");
        this.itemNameInput.getStyle().removeProperty("display");
        this.extraDiv.getStyle().removeProperty("display");
        this.itemNameInput.focus();
    }

    @Override
    public void finishItemEdition() {
        this.itemName.getStyle().removeProperty("display");
        this.itemNameInput.getStyle().setProperty("display", "none");
        this.extraDiv.getStyle().setProperty("display", "none");
    }

    @Override
    public void setContextWidget(IsWidget widget) {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.extraDiv);
        com.google.gwt.user.client.Element el = widget.asWidget().getElement();
        el.getStyle().setWidth(150.0, Style.Unit.PX);
        this.extraDiv.appendChild((org.jboss.errai.common.client.dom.Node)el);
    }

    @Override
    public void setItemEditable(boolean editable) {
        if (editable) {
            this.itemName.getStyle().setProperty("cursor", "pointer");
        } else {
            this.itemName.getStyle().removeProperty("cursor");
        }
    }

    @Override
    public String i18nNewItem(String item) {
        return this.i18n.newItem(item);
    }

    @Override
    public String i18nGotoItem(String item) {
        return this.i18n.gotoItem(item);
    }

    @Override
    public String i18nDeleteItem() {
        return this.i18n.deleteItem();
    }

    @Override
    public String i18nMoveUp() {
        return this.i18n.moveUp();
    }

    @Override
    public String i18nMoveDown() {
        return this.i18n.moveDown();
    }

    @Override
    public String i18nMoveFirst() {
        return this.i18n.moveFirst();
    }

    @Override
    public String i18nMoveLast() {
        return this.i18n.moveLast();
    }

    @EventHandler(value={"itemName"})
    public void onItemNameClick(ClickEvent event) {
        this.presenter.onItemClick();
    }

    @EventHandler(value={"itemNameInput"})
    public void onItemNameInputOver(MouseOverEvent event) {
        this.itemNameInput.focus();
    }

    @EventHandler(value={"itemNameInput"})
    public void onItemNameChanged(ChangeEvent event) {
        this.presenter.onItemNameChanged(this.itemNameInput.getValue());
    }
}

