/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.plugin;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.layout.LayoutRecursionIssue;
import org.dashbuilder.navigation.layout.LayoutTemplateContext;
import org.dashbuilder.navigation.layout.LayoutTemplateInfo;
import org.dashbuilder.navigation.service.PerspectivePluginServices;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.layout.editor.api.editor.LayoutInstance;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.generator.LayoutGenerator;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.ActivityResourceType;

@EntryPoint
@ApplicationScoped
public class PerspectivePluginManager {
    private ClientTypeRegistry clientTypeRegistry;
    private LayoutGenerator layoutGenerator;
    private NavigationManager navigationManager;
    private Caller<PerspectivePluginServices> pluginServices;
    private Event<PerspectivePluginsChangedEvent> perspectivesChangedEvent;
    private Map<String, Plugin> pluginMap = new HashMap<String, Plugin>();
    private boolean pluginsLoaded = false;
    private Stack<NavGroup> navGroupStack = new Stack();

    @Inject
    public PerspectivePluginManager(ClientTypeRegistry clientTypeRegistry, LayoutGenerator layoutGenerator, NavigationManager navigationManager, Caller<PerspectivePluginServices> pluginServices, Event<PerspectivePluginsChangedEvent> perspectivesChangedEvent) {
        this.clientTypeRegistry = clientTypeRegistry;
        this.layoutGenerator = layoutGenerator;
        this.navigationManager = navigationManager;
        this.pluginServices = pluginServices;
        this.perspectivesChangedEvent = perspectivesChangedEvent;
    }

    @PostConstruct
    private void init() {
        this.loadPlugins((ParameterizedCommand<Collection<Plugin>>)((ParameterizedCommand)plugins -> {}));
    }

    public void getPerspectivePlugins(ParameterizedCommand<Collection<Plugin>> callback) {
        this.loadPlugins(callback);
    }

    private void loadPlugins(ParameterizedCommand<Collection<Plugin>> callback) {
        if (this.pluginsLoaded) {
            callback.execute(this.pluginMap.values());
        } else {
            ((PerspectivePluginServices)this.pluginServices.call(plugins -> {
                this.pluginMap.clear();
                plugins.stream().filter(this::isRuntimePerspective).forEach(p -> this.pluginMap.put(p.getName(), (Plugin)p));
                this.pluginsLoaded = true;
                callback.execute(this.pluginMap.values());
            })).listPlugins();
        }
    }

    public boolean isRuntimePerspective(Plugin plugin) {
        ClientResourceType type = this.clientTypeRegistry.resolve(plugin.getPath());
        return type != null && type instanceof PerspectiveLayoutPluginResourceType;
    }

    public boolean isRuntimePerspective(NavItem navItem) {
        return this.getRuntimePerspectiveId(navItem) != null;
    }

    public boolean isRuntimePerspective(String perspectiveId) {
        return this.pluginMap.containsKey(perspectiveId);
    }

    public String getRuntimePerspectiveId(NavItem navItem) {
        NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)navItem);
        String resourceId = navCtx.getResourceId();
        ActivityResourceType resourceType = navCtx.getResourceType();
        boolean isRuntimePerspective = resourceId != null && ActivityResourceType.PERSPECTIVE.equals((Object)resourceType) && this.isRuntimePerspective(resourceId);
        return isRuntimePerspective ? resourceId : null;
    }

    public boolean existsPerspectivePlugin(String perspectiveName) {
        return perspectiveName != null && this.pluginMap.get(perspectiveName) != null;
    }

    public void buildPerspectiveWidget(String perspectiveName, ParameterizedCommand<IsWidget> afterBuild, ParameterizedCommand<LayoutRecursionIssue> onInfiniteRecursion) {
        this.buildPerspectiveWidget(perspectiveName, null, afterBuild, onInfiniteRecursion);
    }

    public void getLayoutTemplateInfo(String perspectiveName, ParameterizedCommand<LayoutTemplateInfo> callback) {
        ((PerspectivePluginServices)this.pluginServices.call(arg_0 -> callback.execute(arg_0))).getLayoutTemplateInfo(perspectiveName);
    }

    public void getLayoutTemplateInfo(LayoutTemplate layoutTemplate, ParameterizedCommand<LayoutTemplateInfo> callback) {
        ((PerspectivePluginServices)this.pluginServices.call(arg_0 -> callback.execute(arg_0))).getLayoutTemplateInfo(layoutTemplate);
    }

    public void buildPerspectiveWidget(String perspectiveName, LayoutTemplateContext layoutCtx, ParameterizedCommand<IsWidget> afterBuild, ParameterizedCommand<LayoutRecursionIssue> onInfiniteRecursion) {
        Plugin plugin = this.pluginMap.get(perspectiveName);
        ((PerspectivePluginServices)this.pluginServices.call(layoutInfo -> {
            if (!layoutInfo.getRecursionIssue().isEmpty()) {
                onInfiniteRecursion.execute((Object)layoutInfo.getRecursionIssue());
            } else {
                String navGroupId = layoutCtx != null && layoutCtx.getNavGroupId() != null ? layoutCtx.getNavGroupId() : null;
                NavGroup navGroup = navGroupId != null ? (NavGroup)this.navigationManager.getNavTree().getItemById(navGroupId) : null;
                try {
                    if (navGroup != null) {
                        this.navGroupStack.push(navGroup);
                    }
                    LayoutInstance result = this.layoutGenerator.build(layoutInfo.getLayoutTemplate());
                    ElementWrapperWidget widget = ElementWrapperWidget.getWidget((HTMLElement)result.getElement());
                    afterBuild.execute((Object)widget);
                }
                finally {
                    if (navGroup != null) {
                        this.navGroupStack.pop();
                    }
                }
            }
        })).getLayoutTemplateInfo(plugin, layoutCtx);
    }

    public NavGroup getLastBuildPerspectiveNavGroup() {
        return this.navGroupStack.isEmpty() ? null : this.navGroupStack.peek();
    }

    public void onPlugInAdded(@Observes PluginAdded event) {
        Plugin plugin = event.getPlugin();
        if (this.isRuntimePerspective(plugin)) {
            this.pluginMap.put(plugin.getName(), plugin);
            this.perspectivesChangedEvent.fire((Object)new PerspectivePluginsChangedEvent());
        }
    }

    public void onPlugInSaved(@Observes PluginSaved event) {
        Plugin plugin = event.getPlugin();
        if (this.isRuntimePerspective(plugin)) {
            this.pluginMap.put(plugin.getName(), plugin);
            this.perspectivesChangedEvent.fire((Object)new PerspectivePluginsChangedEvent());
        }
    }

    public void onPlugInRenamed(@Observes PluginRenamed event) {
        Plugin plugin = event.getPlugin();
        if (this.isRuntimePerspective(plugin)) {
            this.pluginMap.remove(event.getOldPluginName());
            this.pluginMap.put(plugin.getName(), plugin);
            NavWorkbenchCtx ctx = NavWorkbenchCtx.perspective((String)event.getOldPluginName());
            NavWorkbenchCtx newCtx = NavWorkbenchCtx.perspective((String)event.getPlugin().getName());
            List itemsToRename = this.navigationManager.getNavTree().searchItems((NavItemContext)ctx);
            for (NavItem navItem : itemsToRename) {
                navItem.setContext(newCtx.toString());
            }
            if (!itemsToRename.isEmpty()) {
                this.navigationManager.saveNavTree(this.navigationManager.getNavTree(), () -> {});
            }
            this.perspectivesChangedEvent.fire((Object)new PerspectivePluginsChangedEvent());
        }
    }

    public void onPlugInDeleted(@Observes PluginDeleted event) {
        String pluginName = event.getPluginName();
        this.pluginMap.remove(pluginName);
        NavWorkbenchCtx ctx = NavWorkbenchCtx.perspective((String)pluginName);
        NavTree navTree = this.navigationManager.getNavTree();
        List itemsToDelete = navTree.searchItems((NavItemContext)ctx);
        for (NavItem item : itemsToDelete) {
            navTree.deleteItem(item.getId());
        }
        if (!itemsToDelete.isEmpty()) {
            this.navigationManager.saveNavTree(navTree, null);
        }
        this.perspectivesChangedEvent.fire((Object)new PerspectivePluginsChangedEvent());
    }
}

