/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.NavDropDownWidget;
import org.dashbuilder.client.navigation.widget.NavMenuBarWidget;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class NavMenuBarWidgetTest {
    @Mock
    NavMenuBarWidget.View view;
    @Mock
    NavDropDownWidget.View viewAdmin;
    @Mock
    NavDropDownWidget.View viewDashboards;
    @Mock
    SyncBeanDef<NavDropDownWidget> dropDownBean;
    @Mock
    PerspectivePluginManager pluginManager;
    @Mock
    NavigationManager navigationManager;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    PlaceManager placeManager;
    NavDropDownWidget dropDownAdmin;
    NavDropDownWidget dropDownDashboards;
    NavMenuBarWidget presenter;
    NavTree tree;
    public static final String ITEM_ID_HOME = "home";
    public static final String ITEM_ID_GALLERY = "gallery";
    public static final String ITEM_ID_ADMIN = "admin";
    public static final String ITEM_ID_DATASETS = "datasets";
    public static final String ITEM_ID_CONTENTMGMT = "contentmgmt";
    public static final String ITEM_ID_DASHBOARDS = "dashboards";
    public static final String ITEM_ID_DASHBOARD1 = "dashboard1";
    public static final String ITEM_ID_DASHBOARD2 = "dashboard2";

    @Before
    public void setUp() throws Exception {
        this.dropDownAdmin = new NavDropDownWidget(this.viewAdmin, this.beanManager, this.navigationManager);
        this.dropDownDashboards = new NavDropDownWidget(this.viewDashboards, this.beanManager, this.navigationManager);
        this.presenter = new NavMenuBarWidget(this.view, this.beanManager, this.pluginManager, this.placeManager, this.navigationManager);
        this.tree = new NavTreeBuilder().item(ITEM_ID_HOME, "Home", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_HOME)).item(ITEM_ID_GALLERY, "Gallery", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_GALLERY)).group(ITEM_ID_ADMIN, "Administration", null, false).item(ITEM_ID_DATASETS, "Datasets", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_DATASETS)).item(ITEM_ID_CONTENTMGMT, "Content Manager", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_CONTENTMGMT)).endGroup().group(ITEM_ID_DASHBOARDS, "Dashboards", null, false).item(ITEM_ID_DASHBOARD1, "Dashboard 1", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_DASHBOARD1)).item(ITEM_ID_DASHBOARD2, "Dashboard 2", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_DASHBOARD2)).endGroup().build();
        Mockito.when((Object)this.beanManager.lookupBean(NavDropDownWidget.class, new Annotation[0])).thenReturn(this.dropDownBean);
        Mockito.when((Object)this.dropDownBean.newInstance()).thenReturn((Object)this.dropDownAdmin, (Object[])new NavDropDownWidget[]{this.dropDownDashboards});
    }

    @Test
    public void testShowMenuBar() {
        this.presenter.show(this.tree);
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSelectedItem(Mockito.anyString());
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)ITEM_ID_HOME), Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any());
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)ITEM_ID_GALLERY), Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any());
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).addGroupItem((String)Mockito.eq((Object)ITEM_ID_ADMIN), Mockito.anyString(), Mockito.anyString(), (IsWidget)Mockito.eq((Object)this.dropDownAdmin));
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).addGroupItem((String)Mockito.eq((Object)ITEM_ID_DASHBOARDS), Mockito.anyString(), Mockito.anyString(), (IsWidget)Mockito.eq((Object)this.dropDownDashboards));
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewAdmin)).setDropDownName("Administration");
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewAdmin, (VerificationMode)Mockito.never())).setActive(true);
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewAdmin)).addItem((String)Mockito.eq((Object)ITEM_ID_DATASETS), Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any());
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewAdmin)).addItem((String)Mockito.eq((Object)ITEM_ID_CONTENTMGMT), Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any());
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewDashboards)).setDropDownName("Dashboards");
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewDashboards, (VerificationMode)Mockito.never())).setActive(true);
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewDashboards)).addItem((String)Mockito.eq((Object)ITEM_ID_DASHBOARD1), Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any());
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewDashboards)).addItem((String)Mockito.eq((Object)ITEM_ID_DASHBOARD2), Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any());
    }

    @Test
    public void testSelectRootItem() {
        this.presenter.show(this.tree);
        Mockito.reset((Object[])new NavWidgetView[]{this.view, this.viewAdmin, this.viewDashboards});
        this.presenter.setSelectedItem(ITEM_ID_HOME);
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).setSelectedItem(ITEM_ID_HOME);
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewAdmin, (VerificationMode)Mockito.never())).setActive(true);
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewDashboards, (VerificationMode)Mockito.never())).setActive(true);
    }

    @Test
    public void testSelectNestedItem() {
        this.presenter.show(this.tree);
        Mockito.reset((Object[])new NavWidgetView[]{this.view, this.viewAdmin, this.viewDashboards});
        this.presenter.setSelectedItem(ITEM_ID_CONTENTMGMT);
        Assert.assertEquals((Object)this.presenter.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_CONTENTMGMT));
        Assert.assertEquals((Object)this.dropDownAdmin.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_CONTENTMGMT));
        Assert.assertNull((Object)this.dropDownDashboards.getItemSelected());
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).clearSelectedItem();
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewAdmin)).setActive(true);
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewAdmin)).setSelectedItem(ITEM_ID_CONTENTMGMT);
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewDashboards, (VerificationMode)Mockito.never())).setActive(true);
    }

    @Test
    public void testSwitchFromNestedToRoot() {
        this.presenter.show(this.tree);
        this.presenter.setSelectedItem(ITEM_ID_CONTENTMGMT);
        Mockito.reset((Object[])new NavWidgetView[]{this.view, this.viewAdmin, this.viewDashboards});
        this.presenter.onItemClicked(this.tree.getItemById(ITEM_ID_HOME));
        Assert.assertEquals((Object)this.presenter.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_HOME));
        Assert.assertNull((Object)this.dropDownAdmin.getItemSelected());
        Assert.assertNull((Object)this.dropDownDashboards.getItemSelected());
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).clearSelectedItem();
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).setSelectedItem(ITEM_ID_HOME);
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewAdmin)).setActive(false);
        ((NavDropDownWidget.View)Mockito.verify((Object)this.viewDashboards, (VerificationMode)Mockito.never())).setActive(true);
    }

    @Test
    public void testNullNavGroup() {
        this.presenter.show((NavGroup)null);
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).errorNavGroupNotFound();
    }

    @Test
    public void testNullNavTree() {
        this.presenter.show((NavTree)null);
        ((NavMenuBarWidget.View)Mockito.verify((Object)this.view)).errorNavItemsEmpty();
    }
}

