/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import com.google.gwt.user.client.ui.IsWidget;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.editor.TargetPerspectiveEditor;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveDropDown;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class TargetPerspectiveEditorTest {
    @Mock
    TargetPerspectiveEditor.View view;
    @Mock
    PerspectivePluginManager perspectivePluginManager;
    @Mock
    PerspectiveDropDown perspectiveDropDown;
    @Mock
    PerspectiveTreeProvider perspectiveTreeProvider;
    @Mock
    Command updateCommand;
    TargetPerspectiveEditor presenter;
    NavTree NAV_TREE = new NavTreeBuilder().group("root", "root", "root", true).group("level1a", "level1a", "level1a", true).endGroup().group("level1b", "level1b", "level1b", true).endGroup().group("levelnull", null, null, true).group("level2a", "level2a", "level2a", true).endGroup().endGroup().build();

    @Before
    public void setUp() throws Exception {
        this.presenter = new TargetPerspectiveEditor(this.view, this.perspectiveDropDown, this.perspectivePluginManager, this.perspectiveTreeProvider);
        this.presenter.setNavItemList(this.NAV_TREE.getRootItems());
        this.presenter.setPerspectiveId("A");
        this.presenter.setNavGroupId("level1a");
        this.presenter.setOnUpdateCommand(this.updateCommand);
        this.presenter.show();
    }

    @Test
    public void testShow() {
        ((PerspectiveDropDown)Mockito.verify((Object)this.perspectiveDropDown)).setSelectedPerspective("A");
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).setPerspectiveSelector((IsWidget)this.perspectiveDropDown);
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).clearNavGroupItems();
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).setNavGroupSelection((String)Mockito.eq((Object)"root>level1a"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"root"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"root>level1b"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"level2a"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addNavGroupItem(Mockito.anyString(), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addNavGroupItem((String)Mockito.eq((Object)"root>level1a"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addNavGroupItem((String)Mockito.eq((Object)"root>null"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addNavGroupItem((String)Mockito.eq((Object)"null"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addNavGroupItem((String)Mockito.eq((Object)"null>level2a"), (Command)Mockito.any());
    }

    @Test
    public void testGroupChange() {
        Mockito.reset((Object[])new TargetPerspectiveEditor.View[]{this.view});
        this.presenter.onGroupSelected("level1b");
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).clearNavGroupItems();
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).setNavGroupSelection((String)Mockito.eq((Object)"root>level1b"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"root"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"root>level1a"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"level2a"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addNavGroupItem(Mockito.anyString(), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addNavGroupItem((String)Mockito.eq((Object)"root>level1b"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addNavGroupItem((String)Mockito.eq((Object)"root>null"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addNavGroupItem((String)Mockito.eq((Object)"null"), (Command)Mockito.any());
        ((TargetPerspectiveEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addNavGroupItem((String)Mockito.eq((Object)"null>level2a"), (Command)Mockito.any());
        ((Command)Mockito.verify((Object)this.updateCommand)).execute();
    }

    @Test
    public void testPerspectiveName() {
        Mockito.when((Object)this.perspectivePluginManager.isRuntimePerspective("A.1")).thenReturn((Object)true);
        Mockito.when((Object)this.perspectiveTreeProvider.getPerspectiveName("B.1")).thenReturn((Object)"Pretty");
        Assert.assertEquals((Object)this.presenter.getPerspectiveName("A.1"), (Object)"A.1");
        Assert.assertEquals((Object)this.presenter.getPerspectiveName("B.1"), (Object)"Pretty");
    }
}

