/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.uberfire.mvp.Command;

public abstract class BaseNavWidgetView<T>
extends Composite
implements NavWidgetView<T> {
    protected Node navWidget = null;
    protected com.google.gwt.dom.client.Element selectedItem = null;
    protected Map<String, com.google.gwt.dom.client.Element> itemMap = new HashMap<String, com.google.gwt.dom.client.Element>();
    protected Set<IsWidget> widgetSet = new HashSet<IsWidget>();

    protected void appendWidgetToElement(HTMLElement element, IsWidget widget) {
        DOMUtil.appendWidgetToElement((HTMLElement)element, (IsWidget)widget);
        this.widgetSet.add(widget);
    }

    @Override
    public void clearItems() {
        DOMUtil.removeAllChildren((Node)this.navWidget);
        this.widgetSet.forEach(DOMUtil::removeFromParent);
    }

    @Override
    public void addGroupItem(String id, String name, String description, IsWidget widget) {
        Element el = widget.asWidget().getElement();
        this.navWidget.appendChild((Node)el);
    }

    @Override
    public void addItem(String id, String name, String description, Command onItemSelected) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setInnerText(name);
        if (description != null && !description.equals(name)) {
            anchor.setTitle(description);
        }
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((com.google.gwt.dom.client.Node)anchor);
        this.navWidget.appendChild((Node)li);
        this.itemMap.put(id, (com.google.gwt.dom.client.Element)li);
        Event.sinkEvents((com.google.gwt.dom.client.Element)anchor, (int)1);
        Event.setEventListener((com.google.gwt.dom.client.Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                onItemSelected.execute();
            }
        });
    }

    @Override
    public void setSelectedItem(String id) {
        com.google.gwt.dom.client.Element el = this.itemMap.get(id);
        if (el != null) {
            this.clearSelectedItem();
            this.selectedItem = el;
            this.setSelectedEnabled(true);
        }
    }

    @Override
    public void clearSelectedItem() {
        if (this.selectedItem != null) {
            this.setSelectedEnabled(false);
            this.selectedItem = null;
        }
    }

    protected void setSelectedEnabled(boolean enabled) {
        if (enabled) {
            this.selectedItem.setClassName("active");
        } else {
            this.selectedItem.setClassName("");
        }
    }

    @Override
    public void errorNavGroupNotFound() {
        this.addItem("error", NavigationConstants.INSTANCE.navGroupNotFound(), null, () -> {});
    }

    @Override
    public void errorNavItemsEmpty() {
        this.addItem("error", NavigationConstants.INSTANCE.navItemsEmpty(), null, () -> {});
    }

    public String navRefPerspectiveI18n(String name) {
        return NavigationConstants.INSTANCE.navRefPerspective(name);
    }

    public String navRefPerspectiveFoundI18n(String name) {
        return NavigationConstants.INSTANCE.navRefPerspectiveFound(name);
    }

    public String navRefPerspectiveDefaultI18n(String name) {
        return NavigationConstants.INSTANCE.navRefPerspectiveDefault(name);
    }

    public String navRefPerspectiveInGroupI18n(String name) {
        return NavigationConstants.INSTANCE.navRefPerspectiveInGroup(name);
    }

    public String navRefComponentI18n(String name) {
        return NavigationConstants.INSTANCE.navRefComponent(name);
    }

    public String navRefGroupDefinedI18n(String name) {
        return NavigationConstants.INSTANCE.navRefGroupDefined(name);
    }

    public String navRefGroupContextI18n(String name) {
        return NavigationConstants.INSTANCE.navRefGroupContext(name);
    }

    public String navRefDefaultItemDefinedI18n(String name) {
        return NavigationConstants.INSTANCE.navRefDefaultItemDefined(name);
    }

    public String navRefDefaultItemFoundI18n(String name) {
        return NavigationConstants.INSTANCE.navRefDefaultItemFound(name);
    }

    public String navRefPerspectiveRecursionEndI18n() {
        return NavigationConstants.INSTANCE.navRefPerspectiveRecursionEnd();
    }

    public String navMenubarDragComponentI18n() {
        return NavigationConstants.INSTANCE.navMenubarDragComponent();
    }

    public String navTreeDragComponentI18n() {
        return NavigationConstants.INSTANCE.navTreeDragComponent();
    }

    public String navTilesDragComponentI18n() {
        return NavigationConstants.INSTANCE.navTilesDragComponent();
    }

    public String navTabListDragComponentI18n() {
        return NavigationConstants.INSTANCE.navTabListDragComponent();
    }

    public String navCarouselDragComponentI18n() {
        return NavigationConstants.INSTANCE.navCarouselDragComponent();
    }
}

