/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditor;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditorView;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditor;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Templated
public class NavTreeEditorView
extends NavItemEditorView<NavTreeEditor>
implements NavTreeEditor.View {
    @Inject
    @DataField
    Div mainDiv;
    @Inject
    @DataField
    Div childrenDiv;
    @Inject
    @DataField
    Div alertDiv;
    @Inject
    @DataField
    Span alertMessage;
    @Inject
    @DataField
    Button saveButton;
    @Inject
    @DataField
    Button cancelButton;
    NavTreeEditor presenter;

    public void init(NavTreeEditor presenter) {
        this.presenter = presenter;
        this.alertMessage.setTextContent(this.i18n.saveChanges());
        this.saveButton.setTextContent(this.i18n.save());
        this.cancelButton.setTextContent(this.i18n.cancel());
    }

    @Override
    public void setExpandEnabled(boolean enabled) {
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.childrenDiv.setHidden(!expanded);
    }

    @Override
    public void clearChildren() {
        DOMUtil.removeAllChildren((Node)this.childrenDiv);
        this.setChangedFlag(false);
    }

    @Override
    public void addChild(IsElement editor) {
        this.childrenDiv.appendChild((Node)editor.getElement());
    }

    @Override
    public void setChangedFlag(boolean on) {
        if (on) {
            this.alertDiv.getStyle().removeProperty("display");
        } else {
            this.alertDiv.getStyle().setProperty("display", "none");
        }
    }

    @EventHandler(value={"saveButton"})
    public void onSaveClicked(ClickEvent event) {
        this.presenter.onSaveClicked();
    }

    @EventHandler(value={"cancelButton"})
    public void onCancelClicked(ClickEvent event) {
        this.presenter.onCancelClicked();
    }

    @Override
    public void setItemName(String name) {
    }

    @Override
    public String getItemName() {
        return null;
    }

    @Override
    public void setItemNameError(boolean hasError) {
    }

    @Override
    public void setItemDescription(String description) {
    }

    @Override
    public void setItemType(NavItemEditor.ItemType type) {
    }

    @Override
    public void clearCommands() {
    }

    @Override
    public void addCommand(String name, Command command) {
    }

    @Override
    public void addCommandDivider() {
    }

    @Override
    public void setCommandsEnabled(boolean enabled) {
    }

    @Override
    public void setItemEditable(boolean editable) {
    }

    @Override
    public void setItemDeletable(boolean deletable) {
    }

    @Override
    public void startItemEdition() {
    }

    @Override
    public void finishItemEdition() {
    }

    @Override
    public void setContextWidget(IsElement widget) {
    }
}

