/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;

@ApplicationScoped
public class NavBarHelper {
    public MenuFactory.TopLevelMenusBuilder<MenuFactory.MenuBuilder> buildMenusFromNavTree(NavTree navTree) {
        if (navTree == null) {
            return null;
        }
        MenuFactory.MenuBuilder builder = null;
        for (NavItem navItem : navTree.getRootItems()) {
            NavWorkbenchCtx navCtx;
            List<MenuItem> childItems;
            if (navItem instanceof NavDivider || navItem instanceof NavGroup && ((NavGroup)navItem).getChildren().isEmpty()) continue;
            builder = builder == null ? MenuFactory.newTopLevelMenu((String)navItem.getName()) : ((MenuFactory.TopLevelMenusBuilder)builder.endMenu()).newTopLevelMenu(navItem.getName());
            if (navItem instanceof NavGroup && !(childItems = this.buildMenuItemsFromNavGroup((NavGroup)navItem)).isEmpty()) {
                builder.withItems(childItems);
            }
            if ((navCtx = NavWorkbenchCtx.get((NavItem)navItem)).getResourceId() == null || !ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) continue;
            PlaceRequest placeRequest = this.resolvePlaceRequest(navCtx.getResourceId());
            builder = (MenuFactory.MenuBuilder)builder.place(placeRequest);
        }
        return builder != null ? (MenuFactory.TopLevelMenusBuilder)builder.endMenu() : null;
    }

    private List<MenuItem> buildMenuItemsFromNavGroup(NavGroup navGroup) {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        for (NavItem navItem : navGroup.getChildren()) {
            NavWorkbenchCtx navCtx;
            List<MenuItem> childItems;
            if (navItem instanceof NavDivider) continue;
            MenuFactory.MenuBuilder builder = MenuFactory.newSimpleItem((String)navItem.getName());
            if (navItem instanceof NavGroup && !(childItems = this.buildMenuItemsFromNavGroup((NavGroup)navItem)).isEmpty()) {
                builder.withItems(childItems);
            }
            if ((navCtx = NavWorkbenchCtx.get((NavItem)navItem)).getResourceId() != null && ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) {
                PlaceRequest placeRequest = this.resolvePlaceRequest(navCtx.getResourceId());
                builder.place(placeRequest);
            }
            MenuItem menuItem = (MenuItem)((MenuFactory.Builder)builder.endMenu()).build().getItems().get(0);
            result.add(menuItem);
        }
        return result;
    }

    public PlaceRequest resolvePlaceRequest(String perspectiveId) {
        return new DefaultPlaceRequest(perspectiveId);
    }
}

