/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.layout.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.layout.editor.NavDragComponent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.HasDefaultNavItem;
import org.dashbuilder.client.navigation.widget.HasTargetDiv;
import org.dashbuilder.client.navigation.widget.NavComponentConfigModal;
import org.dashbuilder.client.navigation.widget.NavComponentConfigModalView;
import org.dashbuilder.client.navigation.widget.NavWidget;
import org.dashbuilder.client.navigation.widget.TargetDivNavWidget;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.event.NavTreeChangedEvent;
import org.dashbuilder.navigation.layout.LayoutTemplateInfo;
import org.gwtbootstrap3.client.ui.Modal;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.TargetDivList;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class AbstractNavDragComponent
implements NavDragComponent {
    NavigationManager navigationManager;
    PerspectivePluginManager pluginManager;
    NavComponentConfigModal navComponentConfigModal;
    NavWidget navWidget;
    String navGroupId = null;
    LayoutTemplate layoutTemplate;

    public AbstractNavDragComponent() {
    }

    public AbstractNavDragComponent(NavigationManager navigationManager, PerspectivePluginManager pluginManager, NavComponentConfigModal navComponentConfigModal, NavWidget navWidget) {
        this.navigationManager = navigationManager;
        this.pluginManager = pluginManager;
        this.navComponentConfigModal = navComponentConfigModal;
        this.navWidget = navWidget;
        this.navWidget.setOnStaleCommand(this::showNavWidget);
    }

    @Override
    public NavWidget getNavWidget() {
        return this.navWidget;
    }

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        return this.getShowWidget(ctx);
    }

    public IsWidget getShowWidget(RenderingContext ctx) {
        Map properties = ctx.getComponent().getProperties();
        NavGroup navGroup = this.pluginManager.getLastBuildPerspectiveNavGroup();
        this.navGroupId = navGroup != null ? navGroup.getId() : (String)properties.get("navGroupId");
        this.navWidget.setHideEmptyGroups(true);
        if (this.navWidget instanceof HasDefaultNavItem) {
            String navItemId = (String)properties.get("navDefaultId");
            ((HasDefaultNavItem)((Object)this.navWidget)).setDefaultNavItemId(navItemId);
        }
        if (this.navWidget instanceof HasTargetDiv) {
            String targetDivId = (String)properties.get("targetDivId");
            ((HasTargetDiv)((Object)this.navWidget)).setTargetDivId(targetDivId);
            ((HasTargetDiv)((Object)this.navWidget)).setGotoItemEnabled(true);
        }
        this.showNavWidget();
        return this.navWidget;
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        List targetDivIdList = TargetDivList.list((LayoutTemplate)ctx.getCurrentLayoutTemplate());
        this.navComponentConfigModal.clear();
        this.navComponentConfigModal.setTargetDivIdList(targetDivIdList);
        NavTree navTree = this.navigationManager.getNavTree();
        String groupId = ctx.getComponentProperty("navGroupId");
        this.navComponentConfigModal.setNavGroup(navTree.getRootItems(), navTree.getItemById(groupId) != null ? groupId : null);
        this.navComponentConfigModal.setNavGroupHelpHint(this.getDragComponentNavGroupHelp());
        boolean supportsDefaultNavItem = this.navWidget instanceof HasDefaultNavItem;
        this.navComponentConfigModal.setDefaultNavItemSupported(supportsDefaultNavItem);
        if (supportsDefaultNavItem) {
            String navItemId = ctx.getComponentProperty("navDefaultId");
            this.navComponentConfigModal.setDefaultNavItemId(navItemId);
        }
        boolean supportsTargetDiv = this.navWidget instanceof HasTargetDiv;
        this.navComponentConfigModal.setTargetDivSupported(supportsTargetDiv);
        if (supportsTargetDiv) {
            String targetDivId = ctx.getComponentProperty("targetDivId");
            this.navComponentConfigModal.setTargetDiv(targetDivId);
            this.layoutTemplate = ctx.getCurrentLayoutTemplate();
        }
        this.navComponentConfigModal.setOnOk(() -> this.navConfigOk(ctx, supportsDefaultNavItem, supportsTargetDiv));
        this.navComponentConfigModal.setOnCancel(() -> this.navConfigCancel(ctx));
        this.navComponentConfigModal.show();
        return ((NavComponentConfigModalView)this.navComponentConfigModal.getView()).getModal();
    }

    @Override
    public void dispose() {
        this.navWidget.dispose();
    }

    protected void showNavWidget() {
        if (this.navGroupId != null) {
            NavGroup navGroup = (NavGroup)this.navigationManager.getNavTree().getItemById(this.navGroupId);
            this.navWidget.show(navGroup);
        } else {
            this.navWidget.show(Collections.emptyList());
        }
    }

    protected void navConfigOk(ModalConfigurationContext ctx, boolean supportsDefaultNavItem, boolean supportsTargetDiv) {
        this.navGroupId = this.navComponentConfigModal.getGroupId();
        if (this.navGroupId != null) {
            ctx.setComponentProperty("navGroupId", this.navGroupId);
        } else {
            ctx.removeComponentProperty("navGroupId");
        }
        String defaultItemId = this.navComponentConfigModal.getDefaultItemId();
        if (supportsDefaultNavItem && defaultItemId != null) {
            ctx.setComponentProperty("navDefaultId", defaultItemId);
        } else {
            ctx.removeComponentProperty("navDefaultId");
        }
        String targetDivId = this.navComponentConfigModal.getTargetDivId();
        if (supportsTargetDiv && targetDivId != null) {
            ctx.setComponentProperty("targetDivId", targetDivId);
            this.checkLayoutTemplate();
        } else {
            ctx.removeComponentProperty("targetDivId");
        }
        ctx.configurationFinished();
    }

    protected void navConfigCancel(ModalConfigurationContext ctx) {
        ctx.configurationCancelled();
    }

    protected void checkLayoutTemplate() {
        if (this.navWidget instanceof TargetDivNavWidget && this.layoutTemplate != null) {
            this.pluginManager.getLayoutTemplateInfo(this.layoutTemplate, (ParameterizedCommand<LayoutTemplateInfo>)((ParameterizedCommand)layoutTemplateInfo -> {
                if (!layoutTemplateInfo.getRecursionIssue().isEmpty()) {
                    TargetDivNavWidget targetDivNavWidget = (TargetDivNavWidget)this.navWidget;
                    targetDivNavWidget.onInfiniteRecursion(layoutTemplateInfo.getRecursionIssue());
                }
            }));
        }
    }

    public void onNavTreeChanged(@Observes NavTreeChangedEvent event) {
        this.checkLayoutTemplate();
    }
}

