/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.BaseNavWidgetView;
import org.dashbuilder.client.navigation.widget.NavCarouselWidget;
import org.dashbuilder.common.client.widgets.AlertBox;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class NavCarouselWidgetView
extends BaseNavWidgetView<NavCarouselWidget>
implements NavCarouselWidget.View {
    @Inject
    @DataField
    Div mainDiv;
    @Inject
    @DataField
    Div carouselDiv;
    @Inject
    @DataField
    Div slidesDiv;
    NavCarouselWidget presenter;
    AlertBox alertBox;

    @Inject
    public NavCarouselWidgetView(AlertBox alertBox) {
        this.alertBox = alertBox;
        alertBox.setLevel(AlertBox.Level.WARNING);
        alertBox.setCloseEnabled(false);
        alertBox.getElement().getStyle().setProperty("width", "96%");
    }

    public void init(NavCarouselWidget presenter) {
        this.presenter = presenter;
        this.navWidget = this.slidesDiv;
    }

    @Override
    public void addDivider() {
    }

    @Override
    public void addContentSlide(IsWidget widget) {
        DOMUtil.removeAllChildren((Node)this.mainDiv);
        this.mainDiv.appendChild((Node)this.carouselDiv);
        Div div = (Div)Window.getDocument().createElement("div");
        div.setClassName(this.slidesDiv.getChildNodes().getLength() == 0 ? "item active" : "item");
        super.appendWidgetToElement((HTMLElement)div, widget);
        this.slidesDiv.appendChild((Node)div);
    }

    @Override
    public void errorNavGroupNotFound() {
        DOMUtil.removeAllChildren((Node)this.mainDiv);
        this.alertBox.setMessage(NavigationConstants.INSTANCE.navGroupNotFound());
        this.mainDiv.appendChild((Node)this.alertBox.getElement());
    }

    @Override
    public void errorNavItemsEmpty() {
        DOMUtil.removeAllChildren((Node)this.mainDiv);
        this.alertBox.setMessage(NavigationConstants.INSTANCE.navCarouselDragComponentEmptyError());
        this.mainDiv.appendChild((Node)this.alertBox.getElement());
    }

    @Override
    public void infiniteRecursionError(String cause) {
        Div div = (Div)Window.getDocument().createElement("div");
        div.setClassName(this.slidesDiv.getChildNodes().getLength() == 0 ? "item active" : "item");
        this.alertBox.setMessage(NavigationConstants.INSTANCE.navCarouselDragComponentInfiniteRecursion() + " " + cause);
        div.appendChild((Node)this.alertBox.getElement());
        this.slidesDiv.appendChild((Node)div);
    }
}

