/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.widget.NavTabListWidget;
import org.dashbuilder.client.navigation.widget.TargetDivNavWidgetView;
import org.dashbuilder.common.client.widgets.AlertBox;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class NavTabListWidgetView
extends TargetDivNavWidgetView<NavTabListWidget>
implements NavTabListWidget.View {
    @Inject
    @DataField
    Div mainDiv;
    @Inject
    @DataField
    Div tabsDiv;
    @Inject
    @DataField
    UnorderedList tabList;
    @Inject
    @DataField
    Div childrenDiv;
    NavTabListWidget presenter;

    @Inject
    public NavTabListWidgetView(AlertBox alertBox) {
        super(alertBox);
    }

    public void init(NavTabListWidget presenter) {
        this.presenter = presenter;
        this.navWidget = this.tabList;
    }

    @Override
    public void addDivider() {
    }

    @Override
    public void addGroupItem(String id, String name, String description, IsWidget widget) {
        this.addItem(id, name, description, () -> this.presenter.onGroupTabClicked(id));
    }

    @Override
    public void showAsSubmenu(boolean enabled) {
        this.tabList.setClassName("nav nav-tabs" + (enabled ? " nav-tabs-pf" : ""));
    }

    @Override
    public void clearChildrenTabs() {
        DOMUtil.removeAllChildren((Node)this.childrenDiv);
    }

    @Override
    public void showChildrenTabs(IsWidget tabListWidget) {
        DOMUtil.removeAllChildren((Node)this.childrenDiv);
        super.appendWidgetToElement((HTMLElement)this.childrenDiv, tabListWidget);
        if (this.presenter.getLevel() == 0) {
            this.childrenDiv.getStyle().setProperty("margin-left", "15px");
        }
    }

    @Override
    public void clearItems() {
        super.clearItems();
        DOMUtil.removeAllChildren((Node)this.mainDiv);
        this.mainDiv.appendChild((Node)this.tabsDiv);
    }

    @Override
    public void error(String message) {
        DOMUtil.removeAllChildren((Node)this.mainDiv);
        this.alertBox.setMessage(message);
        this.mainDiv.appendChild((Node)this.alertBox.getElement());
    }
}

