/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.ChartPackage;
import com.googlecode.gwt.charts.client.DataSource;
import com.googlecode.gwt.charts.client.corechart.BubbleChart;
import com.googlecode.gwt.charts.client.corechart.BubbleChartOptions;
import com.googlecode.gwt.charts.client.corechart.CoreChartWidget;
import com.googlecode.gwt.charts.client.options.Animation;
import com.googlecode.gwt.charts.client.options.AnimationEasing;
import com.googlecode.gwt.charts.client.options.Options;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.google.client.GoogleCategoriesDisplayer;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;

public class GoogleBubbleChartDisplayer
extends GoogleCategoriesDisplayer {
    private BubbleChart chart;
    protected Panel filterPanel = new SimplePanel();

    @Override
    public ChartPackage getPackage() {
        return ChartPackage.CORECHART;
    }

    @Override
    public Widget createVisualization() {
        this.chart = new BubbleChart();
        this.chart.addSelectHandler(this.createSelectHandler((CoreChartWidget)this.chart));
        this.chart.draw((DataSource)this.createTable(), (Options)this.createOptions());
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        FlowPanel container = new FlowPanel();
        container.add((Widget)titleHtml);
        container.add((Widget)this.filterPanel);
        container.add((Widget)this.chart);
        return container;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(5)).setMinColumns(5)).setExtraColumnsAllowed(false)).setGroupsTitle(GoogleDisplayerConstants.INSTANCE.common_Categories()).setColumnsTitle(GoogleDisplayerConstants.INSTANCE.common_Values()).setColumnTitle(Integer.valueOf(1), GoogleDisplayerConstants.INSTANCE.googleBubbleDisplayer_XAxis()).setColumnTitle(Integer.valueOf(2), GoogleDisplayerConstants.INSTANCE.googleBubbleDisplayer_YAxis()).setColumnTitle(Integer.valueOf(3), GoogleDisplayerConstants.INSTANCE.googleBubbleDisplayer_BubbleColor()).setColumnTitle(Integer.valueOf(4), GoogleDisplayerConstants.INSTANCE.googleBubbleDisplayer_BubbleSize()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER, ColumnType.NUMBER, ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP);
    }

    @Override
    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = this.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        this.chart.draw((DataSource)this.createTable(), (Options)this.createOptions());
    }

    private BubbleChartOptions createOptions() {
        Animation anim = Animation.create();
        anim.setDuration(700);
        anim.setEasing(AnimationEasing.IN_AND_OUT);
        BubbleChartOptions options = BubbleChartOptions.create();
        options.setWidth(this.displayerSettings.getChartWidth());
        options.setHeight(this.displayerSettings.getChartHeight());
        options.setBackgroundColor(this.displayerSettings.getChartBackgroundColor());
        if (this.displayerSettings.isXAxisShowLabels()) {
            options.setHAxis(this.createHAxis());
        }
        if (this.displayerSettings.isYAxisShowLabels()) {
            options.setVAxis(this.createVAxis());
        }
        options.setChartArea(this.createChartArea());
        options.setLegend(this.createChartLegend());
        options.setAnimation(anim);
        String[] colors = this.createColorArray(this.googleTable);
        if (colors.length > 0) {
            options.setColors(colors);
        }
        return options;
    }
}

