/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.ChartPackage;
import com.googlecode.gwt.charts.client.ColumnType;
import com.googlecode.gwt.charts.client.DataTable;
import com.googlecode.gwt.charts.client.format.DateFormat;
import com.googlecode.gwt.charts.client.format.DateFormatOptions;
import com.googlecode.gwt.charts.client.format.NumberFormat;
import com.googlecode.gwt.charts.client.format.NumberFormatOptions;
import java.util.Date;
import java.util.List;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServiceError;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;

public abstract class GoogleDisplayer
extends AbstractDisplayer {
    protected FlowPanel panel = new FlowPanel();
    protected Label label = new Label();
    protected DataSet dataSet;
    protected DataTable googleTable = null;

    public GoogleDisplayer() {
        this.initWidget((Widget)this.panel);
    }

    public void draw() {
        if (!super.isDrawn()) {
            if (this.displayerSettings == null) {
                this.displayMessage(GoogleDisplayerConstants.INSTANCE.googleDisplayer_error() + GoogleDisplayerConstants.INSTANCE.googleDisplayer_error_settings_unset());
            } else if (this.dataSetHandler == null) {
                this.displayMessage(GoogleDisplayerConstants.INSTANCE.googleDisplayer_error() + GoogleDisplayerConstants.INSTANCE.googleDisplayer_error_handler_unset());
            } else {
                try {
                    String initMsg = GoogleDisplayerConstants.INSTANCE.googleDisplayer_initalizing();
                    this.displayMessage(initMsg + " ...");
                    this.beforeDataSetLookup();
                    this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                        public void callback(DataSet result) {
                            GoogleDisplayer.this.dataSet = result;
                            GoogleDisplayer.this.afterDataSetLookup(result);
                            Widget w = GoogleDisplayer.this.createVisualization();
                            GoogleDisplayer.this.panel.clear();
                            GoogleDisplayer.this.panel.add(w);
                            String id = GoogleDisplayer.this.getDisplayerId();
                            if (!StringUtils.isBlank((String)id)) {
                                GoogleDisplayer.this.panel.getElement().setId(id);
                            }
                            GoogleDisplayer.this.afterDraw();
                        }

                        public void notFound() {
                            GoogleDisplayer.this.displayMessage(GoogleDisplayerConstants.INSTANCE.googleDisplayer_error() + GoogleDisplayerConstants.INSTANCE.googleDisplayer_error_dataset_notfound());
                        }

                        public boolean onError(DataSetClientServiceError error) {
                            GoogleDisplayer.this.afterError((Displayer)GoogleDisplayer.this, error);
                            return false;
                        }
                    });
                }
                catch (Exception e) {
                    this.displayMessage(GoogleDisplayerConstants.INSTANCE.googleDisplayer_error() + e.getMessage());
                }
            }
        }
    }

    public void redraw() {
        if (!this.isDrawn()) {
            this.draw();
        } else {
            try {
                this.beforeDataSetLookup();
                this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                    public void callback(DataSet result) {
                        GoogleDisplayer.this.dataSet = result;
                        GoogleDisplayer.this.afterDataSetLookup(result);
                        GoogleDisplayer.this.updateVisualization();
                        GoogleDisplayer.this.afterRedraw();
                    }

                    public void notFound() {
                        GoogleDisplayer.this.displayMessage(GoogleDisplayerConstants.INSTANCE.googleDisplayer_error() + GoogleDisplayerConstants.INSTANCE.googleDisplayer_error_dataset_notfound());
                    }

                    public boolean onError(DataSetClientServiceError error) {
                        GoogleDisplayer.this.afterError((Displayer)GoogleDisplayer.this, error);
                        return false;
                    }
                });
            }
            catch (Exception e) {
                this.displayMessage(GoogleDisplayerConstants.INSTANCE.googleDisplayer_error() + e.getMessage());
            }
        }
    }

    public void close() {
        this.panel.clear();
        this.afterClose();
    }

    protected abstract ChartPackage getPackage();

    protected abstract Widget createVisualization();

    protected abstract void updateVisualization();

    protected void beforeDataSetLookup() {
    }

    protected void afterDataSetLookup(DataSet dataSet) {
    }

    public void displayMessage(String msg) {
        this.panel.clear();
        this.panel.add((Widget)this.label);
        this.label.setText(msg);
    }

    public DataTable createTable() {
        DataColumn dataColumn;
        int i;
        this.googleTable = DataTable.create();
        this.googleTable.addRows(this.dataSet.getRowCount());
        List columns = this.dataSet.getColumns();
        for (i = 0; i < columns.size(); ++i) {
            dataColumn = (DataColumn)columns.get(i);
            String columnId = dataColumn.getId();
            org.dashbuilder.dataset.ColumnType columnType = dataColumn.getColumnType();
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
            this.googleTable.addColumn(this.getColumnType(dataColumn), columnSettings.getColumnName(), columnId);
            List columnValues = dataColumn.getValues();
            for (int j = 0; j < columnValues.size(); ++j) {
                Object value = columnValues.get(j);
                if (org.dashbuilder.dataset.ColumnType.DATE.equals((Object)columnType)) {
                    if (value == null) {
                        this.googleTable.setValue(j, i, new Date());
                        continue;
                    }
                    this.googleTable.setValue(j, i, (Date)value);
                    continue;
                }
                if (org.dashbuilder.dataset.ColumnType.NUMBER.equals((Object)columnType)) {
                    if (value == null) {
                        this.googleTable.setValue(j, i, 0.0);
                        continue;
                    }
                    value = super.applyExpression(value.toString(), columnSettings.getValueExpression());
                    this.googleTable.setValue(j, i, Double.parseDouble(value.toString()));
                    continue;
                }
                value = super.formatValue(value, dataColumn);
                this.googleTable.setValue(j, i, value.toString());
            }
        }
        for (i = 0; i < this.googleTable.getNumberOfColumns(); ++i) {
            dataColumn = (DataColumn)columns.get(i);
            ColumnType type = this.googleTable.getColumnType(i);
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
            String pattern = columnSettings.getValuePattern();
            if (ColumnType.DATE.equals((Object)type)) {
                DateFormatOptions dateFormatOptions = DateFormatOptions.create();
                dateFormatOptions.setPattern(pattern);
                DateFormat dateFormat = DateFormat.create((DateFormatOptions)dateFormatOptions);
                dateFormat.format(this.googleTable, i);
                continue;
            }
            if (!ColumnType.NUMBER.equals((Object)type)) continue;
            NumberFormatOptions numberFormatOptions = NumberFormatOptions.create();
            numberFormatOptions.setPattern(pattern);
            NumberFormat numberFormat = NumberFormat.create((NumberFormatOptions)numberFormatOptions);
            numberFormat.format(this.googleTable, i);
        }
        return this.googleTable;
    }

    public ColumnType getColumnType(DataColumn dataColumn) {
        org.dashbuilder.dataset.ColumnType type = dataColumn.getColumnType();
        if (org.dashbuilder.dataset.ColumnType.LABEL.equals((Object)type)) {
            return ColumnType.STRING;
        }
        if (org.dashbuilder.dataset.ColumnType.TEXT.equals((Object)type)) {
            return ColumnType.STRING;
        }
        if (org.dashbuilder.dataset.ColumnType.NUMBER.equals((Object)type)) {
            return ColumnType.NUMBER;
        }
        if (org.dashbuilder.dataset.ColumnType.DATE.equals((Object)type)) {
            return ColumnType.DATE;
        }
        return ColumnType.STRING;
    }
}

