/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.googlecode.gwt.charts.client.ChartLoader;
import com.googlecode.gwt.charts.client.ChartPackage;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractRendererLibrary;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.google.client.GoogleAreaChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleBarChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleBubbleChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleDisplayer;
import org.dashbuilder.renderer.google.client.GoogleLineChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleMapDisplayer;
import org.dashbuilder.renderer.google.client.GoogleMeterChartDisplayer;
import org.dashbuilder.renderer.google.client.GooglePieChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleTableDisplayer;

@ApplicationScoped
public class GoogleRenderer
extends AbstractRendererLibrary {
    public static final String UUID = "gwtcharts";
    private List<DisplayerType> _supportedTypes = Arrays.asList(DisplayerType.BARCHART, DisplayerType.PIECHART, DisplayerType.AREACHART, DisplayerType.LINECHART, DisplayerType.BUBBLECHART, DisplayerType.METERCHART, DisplayerType.TABLE, DisplayerType.MAP);

    public String getUUID() {
        return UUID;
    }

    public String getName() {
        return "GWT Charts";
    }

    public boolean isDefault(DisplayerType type) {
        return this._supportedTypes.contains(type);
    }

    public List<DisplayerType> getSupportedTypes() {
        return this._supportedTypes;
    }

    public List<DisplayerSubType> getSupportedSubtypes(DisplayerType displayerType) {
        switch (displayerType) {
            case BARCHART: {
                return Arrays.asList(DisplayerSubType.BAR, DisplayerSubType.BAR_STACKED, DisplayerSubType.COLUMN, DisplayerSubType.COLUMN_STACKED);
            }
            case PIECHART: {
                return Arrays.asList(DisplayerSubType.PIE, DisplayerSubType.PIE_3D, DisplayerSubType.DONUT);
            }
            case AREACHART: {
                return Arrays.asList(DisplayerSubType.AREA, DisplayerSubType.AREA_STACKED);
            }
            case LINECHART: {
                return Arrays.asList(DisplayerSubType.LINE, DisplayerSubType.SMOOTH);
            }
            case MAP: {
                return Arrays.asList(DisplayerSubType.MAP_REGIONS, DisplayerSubType.MAP_MARKERS);
            }
        }
        return Arrays.asList(new Object[0]);
    }

    public Displayer lookupDisplayer(DisplayerSettings displayerSettings) {
        DisplayerType displayerType = displayerSettings.getType();
        if (DisplayerType.BARCHART.equals((Object)displayerType)) {
            return new GoogleBarChartDisplayer();
        }
        if (DisplayerType.PIECHART.equals((Object)displayerType)) {
            return new GooglePieChartDisplayer();
        }
        if (DisplayerType.AREACHART.equals((Object)displayerType)) {
            return new GoogleAreaChartDisplayer();
        }
        if (DisplayerType.LINECHART.equals((Object)displayerType)) {
            return new GoogleLineChartDisplayer();
        }
        if (DisplayerType.BUBBLECHART.equals((Object)displayerType)) {
            return new GoogleBubbleChartDisplayer();
        }
        if (DisplayerType.METERCHART.equals((Object)displayerType)) {
            return new GoogleMeterChartDisplayer();
        }
        if (DisplayerType.TABLE.equals((Object)displayerType)) {
            return new GoogleTableDisplayer();
        }
        if (DisplayerType.MAP.equals((Object)displayerType)) {
            return new GoogleMapDisplayer();
        }
        return null;
    }

    public void draw(final List<Displayer> displayerList) {
        EnumSet<ChartPackage> packageList = EnumSet.noneOf(ChartPackage.class);
        for (Displayer displayer : displayerList) {
            try {
                GoogleDisplayer googleDisplayer = (GoogleDisplayer)displayer;
                packageList.add(googleDisplayer.getPackage());
            }
            catch (ClassCastException e) {}
        }
        ChartPackage[] packageArray = new ChartPackage[packageList.size()];
        int i = 0;
        for (ChartPackage pkg : packageList) {
            packageArray[i++] = pkg;
        }
        ChartLoader chartLoader = new ChartLoader(packageArray);
        chartLoader.loadApi(new Runnable(){

            @Override
            public void run() {
                GoogleRenderer.super.draw(displayerList);
            }
        });
    }
}

