/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.Pagination;
import com.github.gwtbootstrap.client.ui.Tooltip;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.Bootstrap;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.ChartPackage;
import com.googlecode.gwt.charts.client.DataSource;
import com.googlecode.gwt.charts.client.DataTable;
import com.googlecode.gwt.charts.client.event.SortEvent;
import com.googlecode.gwt.charts.client.event.SortHandler;
import com.googlecode.gwt.charts.client.options.Options;
import com.googlecode.gwt.charts.client.options.TableSort;
import com.googlecode.gwt.charts.client.table.Table;
import com.googlecode.gwt.charts.client.table.TableOptions;
import java.util.List;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.google.client.GoogleDisplayer;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;

public class GoogleTableDisplayer
extends GoogleDisplayer {
    protected int pageSize = 20;
    protected int currentPage = 1;
    protected int numberOfRows = 0;
    protected int numberOfPages = 1;
    protected int pageSelectorSize = 6;
    protected String lastOrderedColumn = null;
    protected SortOrder lastSortOrder = null;
    protected boolean showTotalRowsHint = true;
    protected boolean showTotalPagesHint = true;
    private Table table;
    private HorizontalPanel pagerPanel = new HorizontalPanel();

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = ((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(true).setGroupRequired(false).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle(GoogleDisplayerConstants.INSTANCE.common_Rows()).setColumnsTitle(GoogleDisplayerConstants.INSTANCE.common_Columns());
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute(DisplayerAttributeDef.COLUMN_EMPTY).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.TABLE_GROUP);
    }

    @Override
    public ChartPackage getPackage() {
        return ChartPackage.TABLE;
    }

    @Override
    protected void beforeDataSetLookup() {
        String defaultSortColumn;
        if (this.lastOrderedColumn == null && (defaultSortColumn = this.displayerSettings.getTableDefaultSortColumnId()) != null && !"".equals(defaultSortColumn)) {
            this.lastOrderedColumn = defaultSortColumn;
            this.lastSortOrder = this.displayerSettings.getTableDefaultSortOrder();
        }
        if (this.lastOrderedColumn != null) {
            this.sortApply(this.lastOrderedColumn, this.lastSortOrder);
        }
        int pageSize = this.displayerSettings.getTablePageSize();
        int offset = (this.currentPage - 1) * pageSize;
        this.dataSetHandler.limitDataSetRows(offset, pageSize);
    }

    @Override
    protected void afterDataSetLookup(DataSet dataSet) {
        this.pageSize = this.displayerSettings.getTablePageSize();
        this.numberOfRows = dataSet.getRowCountNonTrimmed();
        this.numberOfPages = (this.numberOfRows - 1) / this.pageSize + 1;
        if (this.currentPage > this.numberOfPages) {
            this.currentPage = 1;
        }
    }

    public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
        this.currentPage = 1;
        super.onFilterEnabled(displayer, groupOp);
    }

    public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
        this.currentPage = 1;
        super.onFilterReset(displayer, groupOps);
    }

    @Override
    public Widget createVisualization() {
        final DataTable dataTable = this.createTable();
        this.table = new Table();
        if (this.displayerSettings.isTableSortEnabled()) {
            this.table.addSortHandler(new SortHandler(){

                public void onSort(SortEvent sortEvent) {
                    GoogleTableDisplayer.this.lastOrderedColumn = dataTable.getColumnId(sortEvent.getColumn());
                    GoogleTableDisplayer.this.lastSortOrder = GoogleTableDisplayer.this.lastSortOrder != null ? GoogleTableDisplayer.this.lastSortOrder.reverse() : SortOrder.ASCENDING;
                    GoogleTableDisplayer.this.redraw();
                }
            });
        }
        this.table.draw((DataSource)dataTable, (Options)this.createOptions());
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        FlowPanel container = new FlowPanel();
        container.add((Widget)titleHtml);
        container.add((Widget)this.table);
        container.add((Widget)this.pagerPanel);
        this.createTablePager();
        return container;
    }

    @Override
    protected void updateVisualization() {
        this.createTablePager();
        this.table.draw((DataSource)this.createTable(), (Options)this.createOptions());
    }

    private TableOptions createOptions() {
        TableOptions options = TableOptions.create();
        options.setSort(TableSort.EVENT);
        options.setPageSize(this.displayerSettings.getTablePageSize());
        options.setShowRowNumber(false);
        int tableWidth = this.displayerSettings.getTableWidth();
        options.setWidth(tableWidth > 0 ? tableWidth : this.dataSet.getColumns().size() * 100);
        return options;
    }

    private void gotoPage(int pageNumber) {
        if (pageNumber != this.currentPage && pageNumber > 0 && pageNumber < this.numberOfPages + 1) {
            this.currentPage = pageNumber;
            super.redraw();
        }
    }

    protected int getLeftMostPageNumber() {
        int page = this.currentPage - this.pageSelectorSize / 2;
        if (page < 1) {
            return 1;
        }
        return page;
    }

    protected int getRightMostPageNumber() {
        int page = this.getLeftMostPageNumber() + this.pageSelectorSize - 1;
        if (page > this.numberOfPages) {
            return this.numberOfPages;
        }
        return page;
    }

    protected void createTablePager() {
        this.pagerPanel.clear();
        this.pagerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.pagerPanel.getElement().setAttribute("cellpadding", "5");
        Pagination pagination = new Pagination();
        pagination.setSize(Pagination.PaginationSize.NORMAL);
        pagination.setAlignment(Bootstrap.Pagination.LEFT.toString());
        for (int i = this.getLeftMostPageNumber(); i <= this.getRightMostPageNumber(); ++i) {
            NavLink pageLink = new NavLink(Integer.toString(i));
            final Integer _currentPage = i;
            if (this.currentPage != i) {
                pageLink.setActive(false);
                pageLink.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        GoogleTableDisplayer.this.gotoPage(_currentPage);
                    }
                });
            } else {
                pageLink.setActive(true);
            }
            pagination.add((Widget)pageLink);
        }
        Icon leftPageIcon = new Icon(IconType.ANGLE_LEFT);
        leftPageIcon.setIconSize(IconSize.LARGE);
        leftPageIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        leftPageIcon.sinkEvents(1);
        leftPageIcon.addHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                GoogleTableDisplayer.this.gotoPage(GoogleTableDisplayer.this.currentPage - 1);
            }
        }, (GwtEvent.Type)ClickEvent.getType());
        Tooltip leftPageTooltip = new Tooltip(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_gotoPreviousPage());
        leftPageTooltip.add((Widget)leftPageIcon);
        Icon rightPageIcon = new Icon(IconType.ANGLE_RIGHT);
        rightPageIcon.setIconSize(IconSize.LARGE);
        rightPageIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        rightPageIcon.sinkEvents(1);
        rightPageIcon.addHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                GoogleTableDisplayer.this.gotoPage(GoogleTableDisplayer.this.currentPage + 1);
            }
        }, (GwtEvent.Type)ClickEvent.getType());
        Tooltip rightPageTooltip = new Tooltip(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_gotoNextPage());
        rightPageTooltip.add((Widget)rightPageIcon);
        Icon firstPageIcon = new Icon(IconType.DOUBLE_ANGLE_LEFT);
        firstPageIcon.setIconSize(IconSize.LARGE);
        firstPageIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        firstPageIcon.sinkEvents(1);
        firstPageIcon.addHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                GoogleTableDisplayer.this.gotoPage(1);
            }
        }, (GwtEvent.Type)ClickEvent.getType());
        Tooltip firstPageTooltip = new Tooltip(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_gotoFirstPage());
        firstPageTooltip.add((Widget)firstPageIcon);
        Icon lastPageIcon = new Icon(IconType.DOUBLE_ANGLE_RIGHT);
        lastPageIcon.setIconSize(IconSize.LARGE);
        lastPageIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        lastPageIcon.sinkEvents(1);
        lastPageIcon.addHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                GoogleTableDisplayer.this.gotoPage(GoogleTableDisplayer.this.numberOfPages);
            }
        }, (GwtEvent.Type)ClickEvent.getType());
        Tooltip lastPageTooltip = new Tooltip(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_gotoLastPage());
        lastPageTooltip.add((Widget)lastPageIcon);
        Label totalPages = null;
        if (this.showTotalPagesHint) {
            totalPages = new Label(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_pages(Integer.toString(this.getLeftMostPageNumber()), Integer.toString(this.getRightMostPageNumber()), Integer.toString(this.numberOfPages)));
        }
        Label totalRows = null;
        if (this.numberOfRows == 0) {
            Label noData = new Label(GoogleDisplayerConstants.INSTANCE.common_noData());
            this.pagerPanel.add((Widget)noData);
        } else if (this.showTotalRowsHint) {
            int currentRowsShown = this.currentPage * this.pageSize > this.numberOfRows ? this.numberOfRows : this.currentPage * this.pageSize;
            totalRows = new Label(GoogleDisplayerConstants.INSTANCE.googleTableDisplayer_rows(Integer.toString((this.currentPage - 1) * this.pageSize + 1), Integer.toString(currentRowsShown), Integer.toString(this.numberOfRows)));
        }
        if (this.numberOfPages > 1) {
            this.pagerPanel.add((IsWidget)firstPageTooltip);
            this.pagerPanel.add((IsWidget)leftPageTooltip);
            this.pagerPanel.add((Widget)pagination);
            this.pagerPanel.add((IsWidget)rightPageTooltip);
            this.pagerPanel.add((IsWidget)lastPageTooltip);
            if (this.showTotalPagesHint || this.showTotalRowsHint) {
                if (totalPages != null) {
                    this.pagerPanel.add((Widget)totalPages);
                }
                if (totalRows != null) {
                    this.pagerPanel.add((Widget)totalRows);
                }
            }
        }
    }
}

