/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.ChartPackage;
import com.googlecode.gwt.charts.client.DataSource;
import com.googlecode.gwt.charts.client.corechart.CoreChartWidget;
import com.googlecode.gwt.charts.client.corechart.PieChart;
import com.googlecode.gwt.charts.client.options.Options;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.renderer.google.client.GoogleCategoriesDisplayer;
import org.dashbuilder.renderer.google.client.PieChartOptionsWrapper;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;

public class GooglePieChartDisplayer
extends GoogleCategoriesDisplayer {
    protected Panel chartPanel = new FlowPanel();
    private PieChart chart;
    protected Panel filterPanel = new SimplePanel();

    @Override
    public ChartPackage getPackage() {
        return ChartPackage.CORECHART;
    }

    public Widget createVisualization() {
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        FlowPanel container = new FlowPanel();
        container.add((Widget)titleHtml);
        container.add((Widget)this.filterPanel);
        container.add((Widget)this.chartPanel);
        this.chart = new PieChart();
        this.chart.addSelectHandler(this.createSelectHandler((CoreChartWidget)this.chart));
        this.updateChartPanel();
        return container;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(2)).setMinColumns(2)).setExtraColumnsAllowed(false)).setGroupsTitle(GoogleDisplayerConstants.INSTANCE.common_Categories()).setColumnsTitle(GoogleDisplayerConstants.INSTANCE.common_Values()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeGroupDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeGroupDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeGroupDef.CHART_RESIZABLE).supportsAttribute(DisplayerAttributeGroupDef.CHART_MAX_WIDTH).supportsAttribute(DisplayerAttributeGroupDef.CHART_MAX_HEIGHT).supportsAttribute(DisplayerAttributeGroupDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP);
    }

    protected void updateChartPanel() {
        this.chartPanel.clear();
        if (this.dataSet.getRowCount() == 0) {
            this.chartPanel.add(super.createNoDataMsgPanel());
        } else {
            this.chart.draw((DataSource)this.createTable(), (Options)this.createOptions().get());
            this.chartPanel.add((Widget)this.chart);
        }
    }

    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = this.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        this.updateChartPanel();
    }

    private PieChartOptionsWrapper createOptions() {
        DisplayerSubType displayerSubType = this.displayerSettings.getSubtype();
        PieChartOptionsWrapper options = PieChartOptionsWrapper.newInstance();
        options.setWidth(this.displayerSettings.getChartWidth());
        options.setHeight(this.displayerSettings.getChartHeight());
        options.setBackgroundColor(this.displayerSettings.getChartBackgroundColor());
        options.setLegend(this.createChartLegend());
        options.setColors(this.createColorArray(this.googleTable));
        options.setChartArea(this.createChartArea());
        options.setIs3D(DisplayerSubType.PIE_3D.equals((Object)displayerSubType));
        options.setHole(DisplayerSubType.DONUT.equals((Object)displayerSubType) ? 0.4 : 0.0);
        return options;
    }
}

