/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.ChartPackage;
import com.googlecode.gwt.charts.client.DataSource;
import com.googlecode.gwt.charts.client.corechart.BarChart;
import com.googlecode.gwt.charts.client.corechart.BarChartOptions;
import com.googlecode.gwt.charts.client.corechart.ColumnChart;
import com.googlecode.gwt.charts.client.corechart.ColumnChartOptions;
import com.googlecode.gwt.charts.client.corechart.CoreChartWidget;
import com.googlecode.gwt.charts.client.options.Animation;
import com.googlecode.gwt.charts.client.options.AnimationEasing;
import com.googlecode.gwt.charts.client.options.CoreOptions;
import com.googlecode.gwt.charts.client.options.Options;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.renderer.google.client.GoogleCategoriesDisplayer;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;

public class GoogleBarChartDisplayer
extends GoogleCategoriesDisplayer {
    protected Panel chartPanel = new FlowPanel();
    protected CoreChartWidget chart;
    protected Panel filterPanel = new SimplePanel();
    private boolean isBarChart = false;
    private boolean isStacked = false;

    @Override
    public ChartPackage getPackage() {
        return ChartPackage.CORECHART;
    }

    public Widget createVisualization() {
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        FlowPanel container = new FlowPanel();
        container.add((Widget)titleHtml);
        container.add((Widget)this.filterPanel);
        container.add((Widget)this.chartPanel);
        this.isBarChart = DisplayerSubType.BAR.equals((Object)this.displayerSettings.getSubtype()) || DisplayerSubType.BAR_STACKED.equals((Object)this.displayerSettings.getSubtype());
        this.isStacked = DisplayerSubType.BAR_STACKED.equals((Object)this.displayerSettings.getSubtype()) || DisplayerSubType.COLUMN_STACKED.equals((Object)this.displayerSettings.getSubtype());
        this.chart = this.isBarChart ? new BarChart() : new ColumnChart();
        this.chart.addSelectHandler(this.createSelectHandler(this.chart));
        this.updateChartPanel();
        return container;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(10)).setMinColumns(2)).setExtraColumnsAllowed(true)).setExtraColumnsType(ColumnType.NUMBER)).setGroupsTitle(GoogleDisplayerConstants.INSTANCE.common_Categories()).setColumnsTitle(GoogleDisplayerConstants.INSTANCE.common_Series()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP);
    }

    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = this.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        this.updateChartPanel();
    }

    protected void updateChartPanel() {
        this.chartPanel.clear();
        if (this.dataSet.getRowCount() == 0) {
            this.chartPanel.add(super.createNoDataMsgPanel());
        } else {
            this.chart.draw((DataSource)this.createTable(), (Options)this.createOptions());
            this.chartPanel.add((Widget)this.chart);
        }
    }

    private CoreOptions createOptions() {
        Animation anim = Animation.create();
        anim.setDuration(700);
        anim.setEasing(AnimationEasing.IN_AND_OUT);
        if (this.isBarChart) {
            BarChartOptions options = BarChartOptions.create();
            options.setWidth(this.displayerSettings.getChartWidth());
            options.setHeight(this.displayerSettings.getChartHeight());
            options.setBackgroundColor(this.displayerSettings.getChartBackgroundColor());
            options.setLegend(this.createChartLegend());
            options.setIsStacked(this.isStacked);
            if (this.displayerSettings.isXAxisShowLabels()) {
                options.setHAxis(this.createHAxis());
            }
            if (this.displayerSettings.isYAxisShowLabels()) {
                options.setVAxis(this.createVAxis());
            }
            options.setAnimation(anim);
            options.setChartArea(this.createChartArea());
            return options;
        }
        ColumnChartOptions options = ColumnChartOptions.create();
        options.setWidth(this.displayerSettings.getChartWidth());
        options.setHeight(this.displayerSettings.getChartHeight());
        options.setBackgroundColor(this.displayerSettings.getChartBackgroundColor());
        options.setLegend(this.createChartLegend());
        options.setIsStacked(this.isStacked);
        if (this.displayerSettings.isXAxisShowLabels()) {
            options.setHAxis(this.createHAxis());
        }
        if (this.displayerSettings.isYAxisShowLabels()) {
            options.setVAxis(this.createVAxis());
        }
        options.setAnimation(anim);
        options.setChartArea(this.createChartArea());
        options.setColors(this.createColorArray(this.googleTable));
        return options;
    }
}

