/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.ChartPackage;
import com.googlecode.gwt.charts.client.DataSource;
import com.googlecode.gwt.charts.client.corechart.CoreChartWidget;
import com.googlecode.gwt.charts.client.corechart.LineChart;
import com.googlecode.gwt.charts.client.corechart.LineChartOptions;
import com.googlecode.gwt.charts.client.options.Animation;
import com.googlecode.gwt.charts.client.options.AnimationEasing;
import com.googlecode.gwt.charts.client.options.CurveType;
import com.googlecode.gwt.charts.client.options.Options;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.renderer.google.client.GoogleCategoriesDisplayer;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;

public class GoogleLineChartDisplayer
extends GoogleCategoriesDisplayer {
    protected Panel chartPanel = new FlowPanel();
    protected LineChart chart;
    protected Panel filterPanel = new SimplePanel();

    @Override
    public ChartPackage getPackage() {
        return ChartPackage.CORECHART;
    }

    public Widget createVisualization() {
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        FlowPanel container = new FlowPanel();
        container.add((Widget)titleHtml);
        container.add((Widget)this.filterPanel);
        container.add((Widget)this.chartPanel);
        this.chart = new LineChart();
        this.chart.addSelectHandler(this.createSelectHandler((CoreChartWidget)this.chart));
        this.updateChartPanel();
        return container;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxGroups(1).setMinColumns(2)).setMaxColumns(10)).setExtraColumnsAllowed(true)).setExtraColumnsType(ColumnType.NUMBER)).setGroupsTitle(GoogleDisplayerConstants.INSTANCE.common_Categories()).setColumnsTitle(GoogleDisplayerConstants.INSTANCE.common_Series()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP);
    }

    protected void updateChartPanel() {
        this.chartPanel.clear();
        if (this.dataSet.getRowCount() == 0) {
            this.chartPanel.add(super.createNoDataMsgPanel());
        } else {
            this.chart.draw((DataSource)this.createTable(), (Options)this.createOptions());
            this.chartPanel.add((Widget)this.chart);
        }
    }

    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = this.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        this.updateChartPanel();
    }

    private LineChartOptions createOptions() {
        Animation anim = Animation.create();
        anim.setDuration(700);
        anim.setEasing(AnimationEasing.IN_AND_OUT);
        boolean isLine = DisplayerSubType.LINE.equals((Object)this.displayerSettings.getSubtype());
        LineChartOptions options = LineChartOptions.create();
        options.setCurveType(isLine ? CurveType.NONE : CurveType.FUNCTION);
        options.setWidth(this.displayerSettings.getChartWidth());
        options.setHeight(this.displayerSettings.getChartHeight());
        options.setBackgroundColor(this.displayerSettings.getChartBackgroundColor());
        if (this.displayerSettings.isXAxisShowLabels()) {
            options.setHAxis(this.createHAxis());
        }
        if (this.displayerSettings.isYAxisShowLabels()) {
            options.setVAxis(this.createVAxis());
        }
        options.setLegend(this.createChartLegend());
        options.setAnimation(anim);
        options.setChartArea(this.createChartArea());
        options.setColors(this.createColorArray(this.googleTable));
        return options;
    }
}

