/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;

public abstract class GoogleDisplayer<V extends View>
extends AbstractDisplayer<V> {
    public void draw() {
        ((View)this.getView()).draw();
    }

    void ready() {
        super.draw();
    }

    protected void createVisualization() {
        if (this.displayerSettings.isTitleVisible()) {
            ((View)this.getView()).showTitle(this.displayerSettings.getTitle());
        }
    }

    protected void updateFilterStatus() {
        ((View)this.getView()).clearFilterStatus();
        Set columnFilters = this.filterColumns();
        if (this.displayerSettings.isFilterEnabled() && !columnFilters.isEmpty()) {
            for (String columnId : columnFilters) {
                List selectedValues = this.filterIntervals(columnId);
                DataColumn column = this.dataSet.getColumnById(columnId);
                for (Interval interval : selectedValues) {
                    String formattedValue = this.formatInterval(interval, column);
                    ((View)this.getView()).addFilterValue(formattedValue);
                }
            }
            ((View)this.getView()).addFilterReset();
        }
    }

    public void pushDataToView() {
        DataColumn dataColumn;
        int i;
        ((View)this.getView()).dataClear();
        ((View)this.getView()).dataRowCount(this.dataSet.getRowCount());
        List columns = this.dataSet.getColumns();
        for (i = 0; i < columns.size(); ++i) {
            dataColumn = (DataColumn)columns.get(i);
            String columnId = dataColumn.getId();
            ColumnType columnType = dataColumn.getColumnType();
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
            ((View)this.getView()).dataAddColumn(dataColumn.getColumnType(), columnId, columnSettings.getColumnName());
            List columnValues = dataColumn.getValues();
            for (int j = 0; j < columnValues.size(); ++j) {
                String valueStr;
                Object value = columnValues.get(j);
                if (ColumnType.DATE.equals((Object)columnType)) {
                    ((View)this.getView()).dataSetValue(j, i, value == null ? new Date() : (Date)value);
                    continue;
                }
                if (ColumnType.NUMBER.equals((Object)columnType)) {
                    if (value == null) {
                        ((View)this.getView()).dataSetValue(j, i, 0.0);
                        continue;
                    }
                    valueStr = this.getEvaluator().evalExpression(value.toString(), columnSettings.getValueExpression());
                    ((View)this.getView()).dataSetValue(j, i, Double.parseDouble(valueStr));
                    continue;
                }
                valueStr = super.formatValue(j, i);
                ((View)this.getView()).dataSetValue(j, i, valueStr);
            }
        }
        for (i = 0; i < this.dataSet.getColumns().size(); ++i) {
            dataColumn = (DataColumn)columns.get(i);
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
            String pattern = columnSettings.getValuePattern();
            if (ColumnType.DATE.equals((Object)dataColumn.getColumnType())) {
                ((View)this.getView()).dataFormatDateColumn(pattern, i);
                continue;
            }
            if (!ColumnType.NUMBER.equals((Object)dataColumn.getColumnType())) continue;
            ((View)this.getView()).dataFormatNumberColumn(pattern, i);
        }
    }

    void onFilterResetClicked() {
        this.filterReset();
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    public static interface View<P extends GoogleDisplayer>
    extends AbstractDisplayer.View<P> {
        public void draw();

        public void dataClear();

        public void dataRowCount(int var1);

        public void dataAddColumn(ColumnType var1, String var2, String var3);

        public void dataSetValue(int var1, int var2, Date var3);

        public void dataSetValue(int var1, int var2, double var3);

        public void dataSetValue(int var1, int var2, String var3);

        public void dataFormatDateColumn(String var1, int var2);

        public void dataFormatNumberColumn(String var1, int var2);

        public String getGroupsTitle();

        public String getColumnsTitle();

        public void showTitle(String var1);

        public void clearFilterStatus();

        public void addFilterValue(String var1);

        public void addFilterReset();
    }
}

