/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.renderer.google.client.GoogleBarChartDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleCategoriesDisplayer;

@Dependent
public class GoogleBarChartDisplayer
extends GoogleCategoriesDisplayer<View> {
    private View view;

    public GoogleBarChartDisplayer() {
        this(new GoogleBarChartDisplayerView());
    }

    @Inject
    public GoogleBarChartDisplayer(View view) {
        this.view = view;
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(10)).setMinColumns(2)).setExtraColumnsAllowed(true)).setExtraColumnsType(ColumnType.NUMBER)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP);
    }

    public boolean isBarChart() {
        return this.displayerSettings.getSubtype() == null || DisplayerSubType.BAR.equals((Object)this.displayerSettings.getSubtype()) || DisplayerSubType.BAR_STACKED.equals((Object)this.displayerSettings.getSubtype());
    }

    public boolean isStacked() {
        return this.displayerSettings.getSubtype() != null && (DisplayerSubType.BAR_STACKED.equals((Object)this.displayerSettings.getSubtype()) || DisplayerSubType.COLUMN_STACKED.equals((Object)this.displayerSettings.getSubtype()));
    }

    @Override
    protected void createVisualization() {
        this.view.setIsBar(this.isBarChart());
        this.view.setIsStacked(this.isStacked());
        super.createVisualization();
    }

    public static interface View
    extends GoogleCategoriesDisplayer.View<GoogleBarChartDisplayer> {
        public void setIsBar(boolean var1);

        public void setIsStacked(boolean var1);
    }
}

