/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.ColumnType;
import com.googlecode.gwt.charts.client.DataTable;
import com.googlecode.gwt.charts.client.format.DateFormat;
import com.googlecode.gwt.charts.client.format.DateFormatOptions;
import com.googlecode.gwt.charts.client.format.NumberFormat;
import com.googlecode.gwt.charts.client.format.NumberFormatOptions;
import java.util.ArrayList;
import java.util.Date;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.displayer.client.AbstractDisplayerView;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.google.client.GoogleDisplayer;
import org.dashbuilder.renderer.google.client.GoogleRenderer;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;
import org.gwtbootstrap3.client.ui.Label;

public abstract class GoogleDisplayerView<P extends GoogleDisplayer>
extends AbstractDisplayerView<P>
implements GoogleDisplayer.View<P> {
    private Panel container = new FlowPanel();
    private Panel filterPanel = new HorizontalPanel();
    private Panel displayerPanel = new FlowPanel();
    private HTML titleHtml = new HTML();
    private DataTable dataTable;
    private GoogleRenderer googleRenderer;

    public void setRenderer(GoogleRenderer googleRenderer) {
        this.googleRenderer = googleRenderer;
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public void showDisplayer(Widget w) {
        this.displayerPanel.clear();
        this.displayerPanel.add(w);
    }

    public void init(P presenter) {
        super.setPresenter(presenter);
        super.setVisualization((Widget)this.container);
        this.container.add((Widget)this.titleHtml);
        this.container.add((Widget)this.filterPanel);
        this.container.add((Widget)this.displayerPanel);
        this.filterPanel.getElement().setAttribute("cellpadding", "2");
    }

    @Override
    public void draw() {
        if (this.googleRenderer == null) {
            ((GoogleDisplayer)this.getPresenter()).showError(new ClientRuntimeError("Google renderer not set"));
        } else if (!((GoogleDisplayer)this.getPresenter()).isDrawn()) {
            ArrayList<Displayer> displayerList = new ArrayList<Displayer>();
            displayerList.add((Displayer)this.getPresenter());
            this.googleRenderer.draw(displayerList);
        }
    }

    @Override
    public void dataClear() {
        this.dataTable = DataTable.create();
    }

    @Override
    public void dataRowCount(int rowCount) {
        this.dataTable.addRows(rowCount);
    }

    @Override
    public void dataAddColumn(org.dashbuilder.dataset.ColumnType type, String id, String name) {
        this.dataTable.addColumn(this.getColumnType(type), name, id);
    }

    @Override
    public void dataSetValue(int row, int column, Date value) {
        this.dataTable.setValue(row, column, value);
    }

    @Override
    public void dataSetValue(int row, int column, double value) {
        this.dataTable.setValue(row, column, value);
    }

    @Override
    public void dataSetValue(int row, int column, String value) {
        this.dataTable.setValue(row, column, value);
    }

    @Override
    public void dataFormatDateColumn(String pattern, int column) {
        DateFormatOptions dateFormatOptions = DateFormatOptions.create();
        dateFormatOptions.setPattern(pattern);
        DateFormat dateFormat = DateFormat.create((DateFormatOptions)dateFormatOptions);
        dateFormat.format(this.dataTable, column);
    }

    @Override
    public void dataFormatNumberColumn(String pattern, int column) {
        NumberFormatOptions numberFormatOptions = NumberFormatOptions.create();
        numberFormatOptions.setPattern(pattern);
        NumberFormat numberFormat = NumberFormat.create((NumberFormatOptions)numberFormatOptions);
        numberFormat.format(this.dataTable, column);
    }

    @Override
    public String getGroupsTitle() {
        return GoogleDisplayerConstants.INSTANCE.common_Categories();
    }

    @Override
    public String getColumnsTitle() {
        return GoogleDisplayerConstants.INSTANCE.common_Series();
    }

    @Override
    public void showTitle(String title) {
        this.titleHtml.setText(title);
    }

    @Override
    public void clearFilterStatus() {
        if (this.filterPanel != null) {
            this.filterPanel.clear();
        }
    }

    @Override
    public void addFilterValue(String value) {
        this.filterPanel.add((Widget)new Label(value));
    }

    @Override
    public void addFilterReset() {
        Anchor anchor = new Anchor(GoogleDisplayerConstants.INSTANCE.googleDisplayer_resetAnchor());
        this.filterPanel.add((Widget)anchor);
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((GoogleDisplayer)GoogleDisplayerView.this.getPresenter()).onFilterResetClicked();
            }
        });
    }

    public ColumnType getColumnType(org.dashbuilder.dataset.ColumnType type) {
        if (org.dashbuilder.dataset.ColumnType.LABEL.equals((Object)type)) {
            return ColumnType.STRING;
        }
        if (org.dashbuilder.dataset.ColumnType.TEXT.equals((Object)type)) {
            return ColumnType.STRING;
        }
        if (org.dashbuilder.dataset.ColumnType.NUMBER.equals((Object)type)) {
            return ColumnType.NUMBER;
        }
        if (org.dashbuilder.dataset.ColumnType.DATE.equals((Object)type)) {
            return ColumnType.DATE;
        }
        return ColumnType.STRING;
    }
}

