/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.google.client.GoogleDisplayer;
import org.dashbuilder.renderer.google.client.GoogleTableDisplayerView;

@Dependent
public class GoogleTableDisplayer
extends GoogleDisplayer<View> {
    protected View view;
    protected int pageSize = 20;
    protected int currentPage = 1;
    protected int numberOfRows = 0;
    protected int numberOfPages = 1;
    protected int pageSelectorSize = 6;
    protected String lastOrderedColumn = null;
    protected SortOrder lastSortOrder = null;
    protected boolean showTotalRowsHint = true;
    protected boolean showTotalPagesHint = true;

    public GoogleTableDisplayer() {
        this(new GoogleTableDisplayerView());
    }

    @Inject
    public GoogleTableDisplayer(View view) {
        this.view = view;
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = ((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(true).setGroupRequired(false).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle());
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute(DisplayerAttributeDef.COLUMN_EMPTY).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.TABLE_GROUP);
    }

    protected void beforeDataSetLookup() {
        String defaultSortColumn;
        if (this.lastOrderedColumn == null && (defaultSortColumn = this.displayerSettings.getTableDefaultSortColumnId()) != null && !"".equals(defaultSortColumn)) {
            this.lastOrderedColumn = defaultSortColumn;
            this.lastSortOrder = this.displayerSettings.getTableDefaultSortOrder();
        }
        if (this.lastOrderedColumn != null) {
            this.sortApply(this.lastOrderedColumn, this.lastSortOrder);
        }
        int pageSize = this.displayerSettings.getTablePageSize();
        int offset = (this.currentPage - 1) * pageSize;
        this.dataSetHandler.limitDataSetRows(offset, pageSize);
    }

    protected void afterDataSetLookup(DataSet dataSet) {
        this.pageSize = this.displayerSettings.getTablePageSize();
        this.numberOfRows = dataSet.getRowCountNonTrimmed();
        this.numberOfPages = (this.numberOfRows - 1) / this.pageSize + 1;
        if (this.currentPage > this.numberOfPages) {
            this.currentPage = 1;
        }
    }

    @Override
    protected void createVisualization() {
        super.createVisualization();
        int tableWidth = this.displayerSettings.getTableWidth();
        this.view.createTable();
        this.view.setSortEnabled(this.displayerSettings.isTableSortEnabled());
        this.view.setTotalPagesHintEnabled(this.showTotalPagesHint);
        this.view.setTotalRowsHintEnabled(this.showTotalRowsHint);
        this.view.setPageSize(this.displayerSettings.getTablePageSize());
        this.view.setWidth(tableWidth > 0 ? tableWidth : this.dataSet.getColumns().size() * 100);
        this.updateVisualization();
    }

    protected void updateVisualization() {
        this.view.setPagerEnabled(this.displayerSettings.getTablePageSize() < this.dataSet.getRowCountNonTrimmed());
        this.view.setCurrentPage(this.currentPage);
        this.view.setTotalRows(this.numberOfRows);
        this.view.setTotalPages(this.numberOfPages);
        this.view.setLeftMostPageNumber(this.getLeftMostPageNumber());
        this.view.setRightMostPageNumber(this.getRightMostPageNumber());
        if (this.numberOfRows == 0) {
            this.view.nodata();
        } else {
            super.pushDataToView();
            this.view.drawTable();
        }
    }

    public void sortBy(String column) {
        if (this.displayerSettings.isTableSortEnabled()) {
            this.lastOrderedColumn = column;
            this.lastSortOrder = this.lastSortOrder != null ? this.lastSortOrder.reverse() : SortOrder.ASCENDING;
            super.redraw();
        }
    }

    public void gotoPage(int pageNumber) {
        if (pageNumber != this.currentPage && pageNumber > 0 && pageNumber < this.numberOfPages + 1) {
            this.currentPage = pageNumber;
            super.redraw();
        }
    }

    public int getLeftMostPageNumber() {
        int page = this.currentPage - this.pageSelectorSize / 2;
        if (page < 1) {
            return 1;
        }
        return page;
    }

    public int getRightMostPageNumber() {
        int page = this.getLeftMostPageNumber() + this.pageSelectorSize - 1;
        if (page > this.numberOfPages) {
            return this.numberOfPages;
        }
        return page;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
        this.currentPage = 1;
        super.onFilterEnabled(displayer, groupOp);
    }

    public void onFilterEnabled(Displayer displayer, DataSetFilter filter) {
        this.currentPage = 1;
        super.onFilterEnabled(displayer, filter);
    }

    public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
        this.currentPage = 1;
        super.onFilterReset(displayer, groupOps);
    }

    public void onFilterReset(Displayer displayer, DataSetFilter filter) {
        this.currentPage = 1;
        super.onFilterReset(displayer, filter);
    }

    public static interface View
    extends GoogleDisplayer.View<GoogleTableDisplayer> {
        public void createTable();

        public void setSortEnabled(boolean var1);

        public void setTotalPagesHintEnabled(boolean var1);

        public void setTotalRowsHintEnabled(boolean var1);

        public void setPageSize(int var1);

        public void setWidth(int var1);

        public void setPagerEnabled(boolean var1);

        public void setCurrentPage(int var1);

        public void setTotalRows(int var1);

        public void setTotalPages(int var1);

        public void setLeftMostPageNumber(int var1);

        public void setRightMostPageNumber(int var1);

        public void nodata();

        public void drawTable();
    }
}

