/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import java.util.List;
import org.dashbuilder.renderer.google.client.GoogleChartDisplayer;

public abstract class GoogleCategoriesDisplayer<V extends View>
extends GoogleChartDisplayer<V> {
    public static final String[] COLOR_ARRAY = new String[]{"blue", "red", "orange", "brown", "coral", "aqua", "fuchsia", "gold", "green", "lime", "magenta", "pink", "silver", "yellow"};
    public static final String COLOR_NOT_SELECTED = "grey";

    protected String[] createColorArray() {
        String[] colorArray = new String[this.dataSet.getRowCount()];
        int i = 0;
        int j = 0;
        while (i < this.dataSet.getRowCount()) {
            if (j >= COLOR_ARRAY.length) {
                j = 0;
            }
            colorArray[i] = COLOR_ARRAY[j];
            List selectedIdxs = this.filterIndexes(this.dataSet.getColumnByIndex(0).getId());
            if (!(this.displayerSettings.isFilterSelfApplyEnabled() || selectedIdxs == null || selectedIdxs.isEmpty() || selectedIdxs.contains(i))) {
                colorArray[i] = COLOR_NOT_SELECTED;
            }
            ++i;
            ++j;
        }
        return colorArray;
    }

    @Override
    protected void createVisualization() {
        super.createVisualization();
        ((View)this.getView()).createChart();
        ((View)this.getView()).setAnimationOn(true);
        ((View)this.getView()).setAnimationDuration(700);
        ((View)this.getView()).setFilterEnabled(this.displayerSettings.isFilterEnabled());
        ((View)this.getView()).setBgColor(this.displayerSettings.getChartBackgroundColor());
        ((View)this.getView()).setShowXLabels(this.displayerSettings.isXAxisShowLabels());
        ((View)this.getView()).setShowYLabels(this.displayerSettings.isYAxisShowLabels());
        ((View)this.getView()).setXAxisTitle(this.displayerSettings.getXAxisTitle());
        ((View)this.getView()).setYAxisTitle(this.displayerSettings.getYAxisTitle());
        ((View)this.getView()).setColors(this.createColorArray());
        this.drawChart();
    }

    protected void updateVisualization() {
        super.updateFilterStatus();
        this.drawChart();
    }

    protected void drawChart() {
        if (this.dataSet.getRowCount() == 0) {
            ((View)this.getView()).nodata();
        } else {
            super.pushDataToView();
            ((View)this.getView()).drawChart();
        }
    }

    public void onCategorySelected(String columnId, int row) {
        Integer maxSelections = this.displayerSettings.isFilterSelfApplyEnabled() ? null : Integer.valueOf(this.dataSet.getRowCount());
        this.filterUpdate(columnId, row, maxSelections);
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    public static interface View<P extends GoogleCategoriesDisplayer>
    extends GoogleChartDisplayer.View<P> {
        public void setFilterEnabled(boolean var1);

        public void setBgColor(String var1);

        public void setShowXLabels(boolean var1);

        public void setShowYLabels(boolean var1);

        public void setXAxisTitle(String var1);

        public void setYAxisTitle(String var1);

        public void setColors(String[] var1);

        public void setAnimationOn(boolean var1);

        public void setAnimationDuration(int var1);

        public void createChart();

        public void nodata();

        public void drawChart();
    }
}

