/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.charts.client.DataSource;
import com.googlecode.gwt.charts.client.Selection;
import com.googlecode.gwt.charts.client.corechart.CoreChartWidget;
import com.googlecode.gwt.charts.client.event.SelectEvent;
import com.googlecode.gwt.charts.client.event.SelectHandler;
import com.googlecode.gwt.charts.client.geochart.GeoChart;
import com.googlecode.gwt.charts.client.options.ChartArea;
import com.googlecode.gwt.charts.client.options.HAxis;
import com.googlecode.gwt.charts.client.options.Options;
import com.googlecode.gwt.charts.client.options.VAxis;
import org.dashbuilder.renderer.google.client.GoogleCategoriesDisplayer;
import org.dashbuilder.renderer.google.client.GoogleChartDisplayerView;
import org.dashbuilder.renderer.google.client.resources.i18n.GoogleDisplayerConstants;
import org.gwtbootstrap3.client.ui.Label;

public abstract class GoogleCategoriesDisplayerView<P extends GoogleCategoriesDisplayer>
extends GoogleChartDisplayerView<P>
implements GoogleCategoriesDisplayer.View<P> {
    private CoreChartWidget chart = null;
    protected String bgColor = null;
    protected boolean showXLabels = false;
    protected boolean showYLabels = false;
    protected String xAxisTitle = null;
    protected String yAxisTitle = null;
    protected int xAxisAngle = 0;
    protected boolean animationOn = false;
    protected int animationDuration = 700;
    protected String[] colors = null;

    @Override
    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    @Override
    public void setShowXLabels(boolean showXLabels) {
        this.showXLabels = showXLabels;
    }

    @Override
    public void setShowYLabels(boolean showYLabels) {
        this.showYLabels = showYLabels;
    }

    @Override
    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
    }

    @Override
    public void setXAxisAngle(int xAxisAngle) {
        this.xAxisAngle = xAxisAngle;
    }

    @Override
    public void setYAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
    }

    @Override
    public void setColors(String[] colors) {
        this.colors = colors;
    }

    @Override
    public void setFilterEnabled(boolean enabled) {
        if (enabled) {
            this.checkChartCreated();
            this.chart.addSelectHandler(this.createSelectHandler(this.chart));
        }
    }

    @Override
    public void setAnimationOn(boolean animationOn) {
        this.animationOn = animationOn;
    }

    @Override
    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
    }

    @Override
    public void createChart() {
        this.chart = this._createChart();
    }

    @Override
    public void drawChart() {
        this.checkChartCreated();
        this.chart.draw((DataSource)this.getDataTable(), this.createOptions());
        super.showDisplayer((Widget)this.chart);
    }

    @Override
    public void nodata() {
        FlowPanel noDataPanel = new FlowPanel();
        noDataPanel.setWidth(this.width + "px");
        noDataPanel.setHeight(this.height + "px");
        noDataPanel.add((Widget)new Label(GoogleDisplayerConstants.INSTANCE.common_noData()));
        super.showDisplayer((Widget)noDataPanel);
    }

    protected void checkChartCreated() {
        if (this.chart == null) {
            throw new RuntimeException("Chart not created. Call to view.createChart() first");
        }
    }

    protected CoreChartWidget _createChart() {
        return null;
    }

    protected Options createOptions() {
        return null;
    }

    protected SelectHandler createSelectHandler(final CoreChartWidget selectable) {
        return new SelectHandler(){

            public void onSelect(SelectEvent event) {
                JsArray selections = selectable.getSelection();
                for (int i = 0; i < selections.length(); ++i) {
                    Selection selection = (Selection)selections.get(i);
                    int row = selection.getRow();
                    GWT.log((String)("Selection column=" + GoogleCategoriesDisplayerView.this.getDataTable().getColumnId(0) + " Row=" + row));
                    ((GoogleCategoriesDisplayer)GoogleCategoriesDisplayerView.this.getPresenter()).onCategorySelected(GoogleCategoriesDisplayerView.this.getDataTable().getColumnId(0), row);
                }
            }
        };
    }

    protected SelectHandler createSelectHandler(final GeoChart selectable) {
        return new SelectHandler(){

            public void onSelect(SelectEvent event) {
                JsArray selections = selectable.getSelection();
                for (int i = 0; i < selections.length(); ++i) {
                    Selection selection = (Selection)selections.get(i);
                    int row = selection.getRow();
                    ((GoogleCategoriesDisplayer)GoogleCategoriesDisplayerView.this.getPresenter()).onCategorySelected(GoogleCategoriesDisplayerView.this.getDataTable().getColumnId(0), row);
                }
            }
        };
    }

    protected ChartArea createChartArea() {
        int chartWidth = this.width - this.marginRight - this.marginLeft;
        int chartHeight = this.height - this.marginTop - this.marginBottom;
        ChartArea chartArea = ChartArea.create();
        chartArea.setLeft((double)this.marginLeft);
        chartArea.setTop((double)this.marginTop);
        chartArea.setWidth((double)chartWidth);
        chartArea.setHeight((double)chartHeight);
        return chartArea;
    }

    protected HAxis createHAxis() {
        HAxis xAxis = this.xAxisTitle == null ? HAxis.create() : HAxis.create((String)this.xAxisTitle);
        xAxis.setSlantedTextAngle(this.xAxisAngle);
        return xAxis;
    }

    protected VAxis createVAxis() {
        return this.yAxisTitle == null ? null : VAxis.create((String)this.yAxisTitle);
    }
}

