/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.postgresql.yugabytedb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.strategy.RetryStrategy;

public class YugabyteDBExecutionTemplate {
    private static final Log LOG = LogFactory.getLog(YugabyteDBExecutionTemplate.class);
    private final JdbcTemplate jdbcTemplate;
    private final String tableName;
    private static final Map<String, Boolean> tableEntries = new ConcurrentHashMap<String, Boolean>();

    YugabyteDBExecutionTemplate(JdbcTemplate jdbcTemplate, String tableName) {
        this.jdbcTemplate = jdbcTemplate;
        this.tableName = tableName;
    }

    public <T> T execute(Callable<T> callable) {
        Exception error = null;
        try {
            this.lock();
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Exception e) {
            error = e;
            throw new FlywayException((Throwable)e);
        }
        finally {
            this.unlock(error);
        }
    }

    private void lock() throws SQLException {
        RetryStrategy strategy = new RetryStrategy();
        strategy.doWithRetries(this::tryLock, "Interrupted while attempting to acquire lock through SELECT ... FOR UPDATE", "Number of retries exceeded while attempting to acquire lock through SELECT ... FOR UPDATE. Configure the number of retries with the 'lockRetryCount' configuration option: https://rd.gt/3A57jfk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLock() {
        FlywaySqlException exception = null;
        boolean txStarted = false;
        boolean success = false;
        Statement statement = null;
        try {
            statement = this.jdbcTemplate.getConnection().createStatement();
            if (!tableEntries.containsKey(this.tableName)) {
                try {
                    statement.executeUpdate("INSERT INTO YB_FLYWAY_LOCK_TABLE VALUES ('" + this.tableName + "', 'false')");
                    tableEntries.put(this.tableName, true);
                    LOG.info(Thread.currentThread().getName() + "> Inserted a token row for " + this.tableName + " in YB_FLYWAY_LOCK_TABLE");
                }
                catch (SQLException e) {
                    if ("23505".equals(e.getSQLState())) {
                        LOG.debug(Thread.currentThread().getName() + "> Token row already added for " + this.tableName);
                    }
                    throw new FlywaySqlException("Could not add token row for " + this.tableName + " in table YB_FLYWAY_LOCK_TABLE", e);
                }
            }
            String selectForUpdate = "SELECT locked FROM YB_FLYWAY_LOCK_TABLE WHERE table_name = '" + this.tableName + "' FOR UPDATE";
            String updateLocked = "UPDATE YB_FLYWAY_LOCK_TABLE SET locked = true WHERE table_name = '" + this.tableName + "'";
            statement.execute("BEGIN");
            txStarted = true;
            ResultSet rs = statement.executeQuery(selectForUpdate);
            if (rs.next()) {
                boolean locked = rs.getBoolean("locked");
                if (locked) {
                    statement.execute("COMMIT");
                    txStarted = false;
                    LOG.debug(Thread.currentThread().getName() + "> Another Flyway operation is in progress. Allowing it to complete");
                } else {
                    LOG.debug(Thread.currentThread().getName() + "> Setting locked = true");
                    statement.executeUpdate(updateLocked);
                    success = true;
                }
            } else {
                tableEntries.remove(this.tableName);
            }
        }
        catch (SQLException e) {
            LOG.warn(Thread.currentThread().getName() + "> Unable to perform lock action, SQLState: " + e.getSQLState());
            if (!"40001".equalsIgnoreCase(e.getSQLState())) {
                exception = new FlywaySqlException("Unable to perform lock action", e);
                throw exception;
            }
        }
        finally {
            if (txStarted) {
                try {
                    statement.execute("COMMIT");
                    LOG.debug(Thread.currentThread().getName() + "> Completed the tx to set locked = true");
                }
                catch (SQLException e) {
                    if (exception == null) {
                        throw new FlywaySqlException("Failed to commit the tx to set locked = true", e);
                    }
                    LOG.warn(Thread.currentThread().getName() + "> Failed to commit the tx to set locked = true: " + String.valueOf(e));
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(Exception rethrow) {
        Statement statement = null;
        try {
            statement = this.jdbcTemplate.getConnection().createStatement();
            statement.execute("BEGIN");
            ResultSet rs = statement.executeQuery("SELECT locked FROM YB_FLYWAY_LOCK_TABLE WHERE table_name = '" + this.tableName + "' FOR UPDATE");
            if (rs.next()) {
                boolean locked = rs.getBoolean("locked");
                if (locked) {
                    statement.executeUpdate("UPDATE YB_FLYWAY_LOCK_TABLE SET locked = false WHERE table_name = '" + this.tableName + "'");
                } else {
                    String msg = "Unlock failed but the Flyway operation may have succeeded. Check your Flyway operation before re-trying";
                    LOG.warn(Thread.currentThread().getName() + "> " + msg);
                    if (rethrow == null) {
                        throw new FlywayException(msg);
                    }
                }
            }
        }
        catch (SQLException e) {
            if (rethrow == null) {
                rethrow = new FlywayException("Unable to perform unlock action", (Throwable)e);
                throw (FlywaySqlException)rethrow;
            }
            LOG.warn("Unable to perform unlock action " + String.valueOf(e));
        }
        finally {
            try {
                statement.execute("COMMIT");
                LOG.debug(Thread.currentThread().getName() + "> Completed the tx to set locked = false");
            }
            catch (SQLException e) {
                if (rethrow == null) {
                    throw new FlywaySqlException("Failed to commit unlock action", e);
                }
                LOG.warn("Failed to commit unlock action: " + String.valueOf(e));
            }
        }
    }
}

