/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.messaging;

import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class JSONSuccessResponse
implements SuccessResponse {
    private JSONObject content;
    private String cacheControl;
    private String pragma;

    public JSONSuccessResponse(@Nonnull JSONObject contentObject) {
        this(contentObject, null, null);
    }

    public JSONSuccessResponse(@Nonnull JSONObject contentObject, @Nullable String cacheControlValue, @Nullable String pragmaValue) {
        Constraint.isNotNull((Object)contentObject, (String)"content cannot be null");
        this.content = contentObject;
        this.cacheControl = cacheControlValue;
        this.pragma = pragmaValue;
    }

    public boolean indicatesSuccess() {
        return true;
    }

    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
        if (this.cacheControl != null) {
            httpResponse.setCacheControl(this.cacheControl);
        }
        if (this.pragma != null) {
            httpResponse.setPragma(this.pragma);
        }
        httpResponse.setContent(this.content.toJSONString());
        return httpResponse;
    }
}

