/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.resolver;

import com.google.common.base.Objects;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.metadata.resolver.ProviderMetadataResolver;
import org.geant.idpextension.oidc.metadata.resolver.RefreshableProviderMetadataResolver;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceableProviderMetadataProvider
extends AbstractServiceableComponent<ProviderMetadataResolver>
implements RefreshableProviderMetadataResolver,
Comparable<ServiceableProviderMetadataProvider> {
    private static int sortKeyValue;
    private final Logger log = LoggerFactory.getLogger(ServiceableProviderMetadataProvider.class);
    @NonnullAfterInit
    private ProviderMetadataResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    public void setSortKey(int key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sortKey = key;
    }

    @Nonnull
    public void setEmbeddedResolver(@Nonnull ProviderMetadataResolver theResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (ProviderMetadataResolver)Constraint.isNotNull((Object)theResolver, (String)"ProviderMetadataResolver cannot be null");
    }

    @Nonnull
    public ProviderMetadataResolver getEmbeddedResolver() {
        return this.resolver;
    }

    @Nonnull
    public Iterable<OIDCProviderMetadata> resolve(ProfileRequestContext profileRequestContext) throws ResolverException {
        return this.resolver.resolve(profileRequestContext);
    }

    @Nullable
    public OIDCProviderMetadata resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        return (OIDCProviderMetadata)this.resolver.resolveSingle(profileRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.resolver) {
            throw new ComponentInitializationException("ProviderMetadataResolver cannot be null");
        }
        if (null == this.sortKey) {
            ServiceableProviderMetadataProvider serviceableProviderMetadataProvider = this;
            synchronized (serviceableProviderMetadataProvider) {
                this.setSortKey(++sortKeyValue);
            }
            this.log.info("Top level ProviderMetadata Provider '{}' did not have a sort key; giving it value '{}'", (Object)this.getId(), (Object)this.sortKey);
        }
    }

    public void setId(@Nonnull @NotEmpty String componentId) {
        super.setId(componentId);
    }

    @Nonnull
    public ProviderMetadataResolver getComponent() {
        return this;
    }

    @Override
    public void refresh() throws ResolverException {
        if (this.resolver instanceof RefreshableProviderMetadataResolver) {
            ((RefreshableProviderMetadataResolver)this.resolver).refresh();
        }
    }

    @Override
    public Instant getLastRefresh() {
        if (this.resolver instanceof RefreshableProviderMetadataResolver) {
            return ((RefreshableProviderMetadataResolver)this.resolver).getLastRefresh();
        }
        return null;
    }

    @Override
    public Instant getLastUpdate() {
        if (this.resolver instanceof RefreshableProviderMetadataResolver) {
            return ((RefreshableProviderMetadataResolver)this.resolver).getLastUpdate();
        }
        return null;
    }

    @Override
    public int compareTo(ServiceableProviderMetadataProvider other) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof ServiceableProviderMetadataProvider)) {
            return false;
        }
        ServiceableProviderMetadataProvider otherRp = (ServiceableProviderMetadataProvider)other;
        return Objects.equal((Object)otherRp.sortKey, (Object)this.sortKey) && Objects.equal((Object)this.getId(), (Object)otherRp.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }
}

