/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.support;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.io.IOException;
import java.net.URI;
import net.minidev.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteJwkUtils {
    private RemoteJwkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JWKSet fetchRemoteJwkSet(String logPrefix, URI uri, HttpClient httpClient, HttpClientSecurityParameters httpClientSecurityParameters) {
        JWKSet jwkSet;
        String output;
        HttpResponse response;
        Logger log = LoggerFactory.getLogger(RemoteJwkUtils.class);
        try {
            HttpUriRequest get = RequestBuilder.get().setUri(uri).build();
            HttpClientContext clientContext = HttpClientContext.create();
            HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)httpClientSecurityParameters, (boolean)true);
            HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpUriRequest)get);
            response = httpClient.execute(get, (HttpContext)clientContext);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)get.getURI().getScheme());
        }
        catch (IOException e) {
            log.error("{} Could not get the JWK contents from {}", new Object[]{logPrefix, uri, e});
            return null;
        }
        if (response == null) {
            log.error("{} Could not get the JWK contents from {}", (Object)logPrefix, (Object)uri);
            return null;
        }
        try {
            output = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException e) {
            log.error("{} Could not parse the JWK contents from {}", (Object)logPrefix, (Object)uri);
            JWKSet jWKSet = null;
            return jWKSet;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        log.trace("{} Fetched the following response body: {}", (Object)logPrefix, (Object)output);
        try {
            JSONObject json = JSONObjectUtils.parse((String)output);
            if (JSONObjectUtils.getJSONArray((JSONObject)json, (String)"keys") == null) {
                log.error("{} Could not find 'keys' array from the JSON from {}", (Object)logPrefix, (Object)uri);
                return null;
            }
            jwkSet = JWKSet.parse((JSONObject)json);
        }
        catch (java.text.ParseException e) {
            log.error("{} Could not parse the contents from {}", new Object[]{logPrefix, uri, e});
            return null;
        }
        return jwkSet;
    }
}

