/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestLoginHintLookupFunction
extends AbstractAuthenticationRequestLookupFunction<String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestLoginHintLookupFunction.class);

    @Override
    String doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("login_hint") != null) {
                Object hint = this.getRequestObject().getJWTClaimsSet().getClaim("login_hint");
                if (hint instanceof String) {
                    return (String)hint;
                }
                this.log.error("login_hint claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse login hint from request object login_hint value");
            return null;
        }
        return req.getLoginHint();
    }
}

