/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestResponseTypeLookupFunction
extends AbstractAuthenticationRequestLookupFunction<ResponseType> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestResponseTypeLookupFunction.class);

    @Override
    ResponseType doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("response_type") != null) {
                return ResponseType.parse((String)((String)this.getRequestObject().getJWTClaimsSet().getClaim("response_type")));
            }
        }
        catch (ParseException | java.text.ParseException e) {
            this.log.error("Unable to parse response type from request object response_type value {}", (Object)e.getMessage());
            return null;
        }
        ResponseType requestParameterScope = new ResponseType();
        requestParameterScope.addAll((Collection)req.getResponseType());
        return requestParameterScope;
    }
}

