/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestedAcrLookupFunction
extends AbstractAuthenticationRequestLookupFunction<List<ACR>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedAcrLookupFunction.class);

    @Override
    List<ACR> doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("acr_values") != null) {
                String[] acrs;
                ArrayList<ACR> reqObjectAcr = new ArrayList<ACR>();
                for (String acr : acrs = ((String)this.getRequestObject().getJWTClaimsSet().getClaim("acr_values")).split(" ")) {
                    reqObjectAcr.add(new ACR(acr));
                }
                return reqObjectAcr;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse acr values from request object acr_values value");
            return null;
        }
        if (req.getACRValues() == null) {
            return null;
        }
        ArrayList<ACR> requestParameterAcr = new ArrayList<ACR>();
        requestParameterAcr.addAll(req.getACRValues());
        return requestParameterAcr;
    }
}

