/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestedPromptLookupFunction
extends AbstractAuthenticationRequestLookupFunction<Prompt> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedPromptLookupFunction.class);

    @Override
    Prompt doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("prompt") != null) {
                return Prompt.parse((String)((String)this.getRequestObject().getJWTClaimsSet().getClaim("prompt")));
            }
        }
        catch (ParseException | java.text.ParseException e) {
            this.log.error("Unable to parse prompt from request object prompt value");
            return null;
        }
        if (req.getPrompt() == null) {
            return null;
        }
        Prompt requestParameterPrompt = new Prompt();
        requestParameterPrompt.addAll((Collection)req.getPrompt());
        return requestParameterPrompt;
    }
}

