/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCMetadataContext;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectorIdentifierLookupFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SectorIdentifierLookupFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadata lookup strategy cannot be null");
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        String sectorIdentifier = null;
        OIDCMetadataContext ctx = this.oidcMetadataContextLookupStrategy.apply(input);
        if (ctx == null || ctx.getClientInformation() == null || ctx.getClientInformation().getOIDCMetadata() == null) {
            this.log.warn("oidc metadata context not available");
        } else if (ctx.getClientInformation().getOIDCMetadata().getSectorIDURI() != null) {
            sectorIdentifier = ctx.getClientInformation().getOIDCMetadata().getSectorIDURI().getHost();
            this.log.debug("sector identifier by sector uri {}", (Object)sectorIdentifier);
        } else if (ctx.getClientInformation().getOIDCMetadata().getRedirectionURIs() != null && ctx.getClientInformation().getOIDCMetadata().getRedirectionURIs().size() > 1) {
            this.log.warn("multiple registered redirection uris, unable to determine sector identifier");
        } else {
            URI redirection = ctx.getClientInformation().getOIDCMetadata().getRedirectionURI();
            if (redirection != null) {
                sectorIdentifier = redirection.getHost();
                this.log.debug("sector identifier by redirect uri {}", (Object)sectorIdentifier);
            } else {
                this.log.warn("redirection uri not available");
            }
        }
        return sectorIdentifier;
    }
}

