/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.oauth2.sdk.TokenRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.context.navigate.AbstractTokenRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRequestRedirectURILookupFunction
extends AbstractTokenRequestLookupFunction<URI> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TokenRequestRedirectURILookupFunction.class);

    @Override
    URI doLookup(TokenRequest req) {
        List redirectURIs = (List)req.getAuthorizationGrant().toParameters().get("redirect_uri");
        if (redirectURIs == null || redirectURIs.isEmpty()) {
            this.log.warn("No redirect_uri parameter");
            return null;
        }
        String redirectURI = (String)redirectURIs.get(0);
        if (redirectURI == null) {
            this.log.warn("No redirect_uri parameter");
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(redirectURI);
        }
        catch (URISyntaxException e) {
            this.log.error("Unable to parse uri from token request redirect_uri {}", (Object)redirectURI);
        }
        return uri;
    }
}

