/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.geant.idpextension.oidc.token.support.TokenClaimsSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessTokenClaimsSet
extends TokenClaimsSet {
    private static final String VALUE_TYPE_AT = "at";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AccessTokenClaimsSet.class);

    public AccessTokenClaimsSet(@Nonnull TokenClaimsSet tokenClaimSet, @Nonnull Scope scope, @Nullable ClaimsSet dlClaims, @Nullable ClaimsSet dlClaimsUI, @Nonnull Instant iat, @Nonnull Instant exp) {
        super(VALUE_TYPE_AT, tokenClaimSet.getID(), tokenClaimSet.getClientID(), tokenClaimSet.getClaimsSet().getIssuer(), tokenClaimSet.getPrincipal(), tokenClaimSet.getClaimsSet().getSubject(), tokenClaimSet.getACR() == null ? null : new ACR(tokenClaimSet.getACR()), iat, exp, tokenClaimSet.getNonce(), tokenClaimSet.getAuthenticationTime(), tokenClaimSet.getRedirectURI(), scope, tokenClaimSet.getClaimsRequest(), dlClaims, null, dlClaimsUI, tokenClaimSet.getConsentableClaims(), tokenClaimSet.getConsentedClaims(), null);
    }

    private AccessTokenClaimsSet(@Nonnull IdentifierGenerationStrategy idGenerator, @Nonnull ClientID clientID, @Nonnull String issuer, @Nonnull String userPrincipal, @Nonnull String subject, @Nullable ACR acr, @Nonnull Instant iat, @Nonnull Instant exp, @Nullable Nonce nonce, @Nonnull Instant authTime, @Nonnull URI redirectURI, @Nonnull Scope scope, @Nullable ClaimsRequest claims, @Nullable ClaimsSet dlClaims, @Nullable ClaimsSet dlClaimsUI, @Nullable JSONArray consentableClaims, @Nullable JSONArray consentedClaims) {
        super(VALUE_TYPE_AT, idGenerator.generateIdentifier(), clientID, issuer, userPrincipal, subject, acr, iat, exp, nonce, authTime, redirectURI, scope, claims, dlClaims, null, dlClaimsUI, consentableClaims, consentedClaims, null);
    }

    private AccessTokenClaimsSet(JWTClaimsSet accessTokenClaimsSet) {
        this.tokenClaimsSet = accessTokenClaimsSet;
    }

    public static AccessTokenClaimsSet parse(String accessTokenClaimsSet) throws ParseException {
        JWTClaimsSet atClaimsSet = JWTClaimsSet.parse((String)accessTokenClaimsSet);
        AccessTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_AT, atClaimsSet);
        return new AccessTokenClaimsSet(atClaimsSet);
    }

    public static AccessTokenClaimsSet parse(@Nonnull String wrappedAccessToken, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return AccessTokenClaimsSet.parse(dataSealer.unwrap(wrappedAccessToken));
    }

    public static class Builder
    extends TokenClaimsSet.Builder<AccessTokenClaimsSet> {
        public Builder(@Nonnull IdentifierGenerationStrategy idGenerator, @Nonnull ClientID clientID, @Nonnull String issuer, @Nonnull String userPrincipal, @Nonnull String subject, @Nonnull Instant issuedAt, @Nonnull Instant expiresAt, @Nonnull Instant authenticationTime, @Nonnull URI redirectURI, @Nonnull Scope scope) {
            super(idGenerator, clientID, issuer, userPrincipal, subject, issuedAt, expiresAt, authenticationTime, redirectURI, scope);
        }

        @Override
        public AccessTokenClaimsSet build() {
            return new AccessTokenClaimsSet(this.idGen, this.rpId, this.iss, this.usrPrincipal, this.sub, this.acr, this.iat, this.exp, this.nonce, this.authTime, this.redirect, this.reqScope, this.claims, this.dlClaims, this.dlClaimsUI, this.cnsntlClaims, this.cnsntdClaims);
        }
    }
}

