/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.geant.idpextension.oidc.token.support.TokenClaimsSet;

public final class AuthorizeCodeClaimsSet
extends TokenClaimsSet {
    public static final String VALUE_TYPE_AC = "ac";

    private AuthorizeCodeClaimsSet(@Nonnull IdentifierGenerationStrategy idGenerator, @Nonnull ClientID clientID, @Nonnull String issuer, @Nonnull String userPrincipal, @Nonnull String subject, @Nonnull ACR acr, @Nonnull Instant iat, @Nonnull Instant exp, @Nullable Nonce nonce, @Nonnull Instant authTime, @Nonnull URI redirectURI, @Nonnull Scope scope, @Nullable ClaimsRequest claims, @Nullable ClaimsSet dlClaims, @Nullable ClaimsSet dlClaimsID, @Nullable ClaimsSet dlClaimsUI, @Nullable JSONArray consentableClaims, @Nullable JSONArray consentedClaims, @Nullable String codeChallenge) {
        super(VALUE_TYPE_AC, idGenerator.generateIdentifier(), clientID, issuer, userPrincipal, subject, acr, iat, exp, nonce, authTime, redirectURI, scope, claims, dlClaims, dlClaimsID, dlClaimsUI, consentableClaims, consentedClaims, codeChallenge);
    }

    private AuthorizeCodeClaimsSet(JWTClaimsSet authzCodeClaimsSet) {
        this.tokenClaimsSet = authzCodeClaimsSet;
    }

    public static AuthorizeCodeClaimsSet parse(String authorizeCodeClaimsSet) throws ParseException {
        JWTClaimsSet acClaimsSet = JWTClaimsSet.parse((String)authorizeCodeClaimsSet);
        AuthorizeCodeClaimsSet.verifyParsedClaims(VALUE_TYPE_AC, acClaimsSet);
        return new AuthorizeCodeClaimsSet(acClaimsSet);
    }

    public static AuthorizeCodeClaimsSet parse(@Nonnull String wrappedAuthCode, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return AuthorizeCodeClaimsSet.parse(dataSealer.unwrap(wrappedAuthCode));
    }

    public static class Builder
    extends TokenClaimsSet.Builder<AuthorizeCodeClaimsSet> {
        public Builder(@Nonnull IdentifierGenerationStrategy idGenerator, @Nonnull ClientID clientID, @Nonnull String issuer, @Nonnull String userPrincipal, @Nonnull String subject, @Nonnull Instant issuedAt, @Nonnull Instant expiresAt, @Nonnull Instant authenticationTime, @Nonnull URI redirectURI, @Nonnull Scope scope) {
            super(idGenerator, clientID, issuer, userPrincipal, subject, issuedAt, expiresAt, authenticationTime, redirectURI, scope);
        }

        @Override
        public AuthorizeCodeClaimsSet build() {
            return new AuthorizeCodeClaimsSet(this.idGen, this.rpId, this.iss, this.usrPrincipal, this.sub, this.acr, this.iat, this.exp, this.nonce, this.authTime, this.redirect, this.reqScope, this.claims, this.dlClaims, this.dlClaimsID, this.dlClaimsUI, this.cnsntlClaims, this.cnsntdClaims, this.codeChallenge);
        }
    }
}

