/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.geant.idpextension.oidc.token.support.TokenDeliveryClaimsClaimsSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenClaimsSet {
    public static final String KEY_AC_ID = "jti";
    public static final String KEY_TYPE = "type";
    public static final String KEY_ISSUER = "iss";
    public static final String KEY_USER_PRINCIPAL = "prncpl";
    public static final String KEY_SUBJECT = "sub";
    public static final String KEY_CLIENTID = "clid";
    public static final String KEY_EXPIRATION_TIME = "exp";
    public static final String KEY_ISSUED_AT = "iat";
    public static final String KEY_ACR = "acr";
    public static final String KEY_NONCE = "nonce";
    public static final String KEY_AUTH_TIME = "auth_time";
    public static final String KEY_REDIRECT_URI = "redirect_uri";
    public static final String KEY_SCOPE = "scope";
    public static final String KEY_CLAIMS = "claims";
    public static final String KEY_DELIVERY_CLAIMS = "dl_claims";
    public static final String KEY_DELIVERY_CLAIMS_IDTOKEN = "dl_claims_id";
    public static final String KEY_DELIVERY_CLAIMS_USERINFO = "dl_claims_ui";
    public static final String KEY_CONSENTABLE_CLAIMS = "cnsntbl_claims";
    public static final String KEY_CONSENTED_CLAIMS = "cnsntd_claims";
    public static final String KEY_CODE_CHALLENGE = "cc";
    protected JWTClaimsSet tokenClaimsSet;
    @Nonnull
    private Logger log = LoggerFactory.getLogger(TokenClaimsSet.class);

    protected TokenClaimsSet() {
    }

    protected TokenClaimsSet(@Nonnull String tokenType, @Nonnull String tokenID, @Nonnull ClientID clientID, @Nonnull String issuer, @Nonnull String userPrincipal, @Nonnull String subject, @Nullable ACR acr, @Nonnull Instant iat, @Nonnull Instant exp, @Nullable Nonce nonce, @Nonnull Instant authTime, @Nonnull URI redirectURI, @Nonnull Scope scope, @Nullable ClaimsRequest claims, @Nullable ClaimsSet dlClaims, @Nullable ClaimsSet dlClaimsID, @Nullable ClaimsSet dlClaimsUI, @Nullable JSONArray consentableClaims, @Nullable JSONArray consentedClaims, @Nullable String codeChallenge) {
        if (tokenType == null || tokenID == null || clientID == null || issuer == null || userPrincipal == null || iat == null || exp == null || authTime == null || redirectURI == null || scope == null || subject == null) {
            throw new RuntimeException("Invalid parameters, programming error");
        }
        this.tokenClaimsSet = new JWTClaimsSet.Builder().claim(KEY_TYPE, (Object)tokenType).jwtID(tokenID).claim(KEY_CLIENTID, (Object)clientID.getValue()).issuer(issuer).subject(subject).claim(KEY_USER_PRINCIPAL, (Object)userPrincipal).claim(KEY_ACR, (Object)(acr == null ? null : acr.getValue())).issueTime(Date.from(iat)).expirationTime(Date.from(exp)).claim(KEY_NONCE, (Object)(nonce == null ? null : nonce.getValue())).claim(KEY_AUTH_TIME, (Object)Date.from(authTime)).claim(KEY_REDIRECT_URI, (Object)redirectURI.toString()).claim(KEY_SCOPE, (Object)scope.toString()).claim(KEY_CLAIMS, (Object)(claims == null ? null : claims.toJSONObject())).claim(KEY_DELIVERY_CLAIMS, (Object)(dlClaims == null ? null : dlClaims.toJSONObject())).claim(KEY_DELIVERY_CLAIMS_IDTOKEN, (Object)(dlClaimsID == null ? null : dlClaimsID.toJSONObject())).claim(KEY_DELIVERY_CLAIMS_USERINFO, (Object)(dlClaimsUI == null ? null : dlClaimsUI.toJSONObject())).claim(KEY_CONSENTABLE_CLAIMS, (Object)consentableClaims).claim(KEY_CONSENTED_CLAIMS, (Object)consentedClaims).claim(KEY_CODE_CHALLENGE, (Object)codeChallenge).build();
    }

    protected static void verifyParsedClaims(@Nonnull String tokenType, @Nonnull JWTClaimsSet tokenClaimsSet) throws ParseException {
        if (!tokenType.equals(tokenClaimsSet.getClaims().get(KEY_TYPE))) {
            throw new ParseException("claim type value not matching", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_ISSUER) == null) {
            throw new ParseException("claim iss must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_USER_PRINCIPAL) == null) {
            throw new ParseException("claim prncpl must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_SUBJECT) == null) {
            throw new ParseException("claim sub must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_CLIENTID) == null) {
            throw new ParseException("claim clid must exist and not be null", 0);
        }
        if (tokenClaimsSet.getDateClaim(KEY_EXPIRATION_TIME) == null) {
            throw new ParseException("claim exp must exist and not be null", 0);
        }
        if (tokenClaimsSet.getDateClaim(KEY_ISSUED_AT) == null) {
            throw new ParseException("claim iat must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_AC_ID) == null) {
            throw new ParseException("claim jti must exist and not be null", 0);
        }
        if (tokenClaimsSet.getDateClaim(KEY_AUTH_TIME) == null) {
            throw new ParseException("claim auth_time must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_REDIRECT_URI) == null) {
            throw new ParseException("claim redirect_uri must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_SCOPE) == null) {
            throw new ParseException("claim scope must exist and not be null", 0);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_ACR)) {
            tokenClaimsSet.getStringClaim(KEY_ACR);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_CONSENTABLE_CLAIMS) && !(tokenClaimsSet.getClaim(KEY_CONSENTABLE_CLAIMS) instanceof JSONArray)) {
            throw new ParseException("consentable claims is of wrong type", 0);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_CONSENTED_CLAIMS) && !(tokenClaimsSet.getClaim(KEY_CONSENTED_CLAIMS) instanceof JSONArray)) {
            throw new ParseException("consented claims is of wrong type", 0);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_CLAIMS)) {
            tokenClaimsSet.getJSONObjectClaim(KEY_CLAIMS);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_DELIVERY_CLAIMS)) {
            tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_DELIVERY_CLAIMS_IDTOKEN)) {
            tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS_IDTOKEN);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_DELIVERY_CLAIMS_USERINFO)) {
            tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS_USERINFO);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_NONCE)) {
            tokenClaimsSet.getStringClaim(KEY_NONCE);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_CODE_CHALLENGE)) {
            tokenClaimsSet.getStringClaim(KEY_CODE_CHALLENGE);
        }
    }

    public String serialize() {
        return this.tokenClaimsSet.toJSONObject().toJSONString();
    }

    public String serialize(@Nonnull DataSealer dataSealer) throws DataSealerException {
        return dataSealer.wrap(this.serialize(), Instant.ofEpochMilli(this.tokenClaimsSet.getExpirationTime().getTime()));
    }

    @Nonnull
    public JWTClaimsSet getClaimsSet() {
        return this.tokenClaimsSet;
    }

    public boolean isExpired() {
        return this.tokenClaimsSet.getExpirationTime().before(new Date());
    }

    @Nonnull
    public Instant getExp() {
        return this.tokenClaimsSet.getExpirationTime().toInstant();
    }

    @Nonnull
    public URI getRedirectURI() {
        try {
            return URI.create(this.tokenClaimsSet.getStringClaim(KEY_REDIRECT_URI));
        }
        catch (ParseException e) {
            this.log.error("error parsing redirect uri from token", (Object)e.getMessage());
            return null;
        }
    }

    @Nonnull
    public String getACR() {
        return (String)this.tokenClaimsSet.getClaim(KEY_ACR);
    }

    @Nonnull
    public String getType() {
        return (String)this.tokenClaimsSet.getClaim(KEY_TYPE);
    }

    @Nonnull
    public String getPrincipal() {
        return (String)this.tokenClaimsSet.getClaim(KEY_USER_PRINCIPAL);
    }

    @Nonnull
    public Instant getAuthenticationTime() {
        try {
            return this.tokenClaimsSet.getDateClaim(KEY_AUTH_TIME).toInstant();
        }
        catch (ParseException e) {
            this.log.error("Error parsing auth time {}", this.tokenClaimsSet.getClaim(KEY_AUTH_TIME));
            return null;
        }
    }

    @Nonnull
    public Nonce getNonce() {
        if (this.tokenClaimsSet.getClaim(KEY_NONCE) == null) {
            return null;
        }
        return new Nonce((String)this.tokenClaimsSet.getClaim(KEY_NONCE));
    }

    @Nullable
    public ClaimsRequest getClaimsRequest() {
        if (this.tokenClaimsSet.getClaim(KEY_CLAIMS) == null) {
            return null;
        }
        try {
            return ClaimsRequest.parse((JSONObject)this.tokenClaimsSet.getJSONObjectClaim(KEY_CLAIMS));
        }
        catch (ParseException e) {
            this.log.error("Error parsing claims request {}", this.tokenClaimsSet.getClaim(KEY_CLAIMS));
            return null;
        }
    }

    public ClaimsSet getDeliveryClaims() {
        TokenDeliveryClaimsClaimsSet claimsSet = new TokenDeliveryClaimsClaimsSet();
        try {
            JSONObject claims = this.tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS);
            if (claims == null) {
                return null;
            }
            claimsSet.putAll((Map)claims);
        }
        catch (ParseException e) {
            this.log.error("Error parsing delivery claims {}", this.tokenClaimsSet.getClaim(KEY_DELIVERY_CLAIMS));
            return null;
        }
        return claimsSet;
    }

    public ClaimsSet getIDTokenDeliveryClaims() {
        TokenDeliveryClaimsClaimsSet claimsSet = new TokenDeliveryClaimsClaimsSet();
        try {
            JSONObject claims = this.tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS_IDTOKEN);
            if (claims == null) {
                return null;
            }
            claimsSet.putAll((Map)claims);
        }
        catch (ParseException e) {
            this.log.error("Error parsing id token delivery claims {}", this.tokenClaimsSet.getClaim(KEY_DELIVERY_CLAIMS_IDTOKEN));
            return null;
        }
        return claimsSet;
    }

    public ClaimsSet getUserinfoDeliveryClaims() {
        TokenDeliveryClaimsClaimsSet claimsSet = new TokenDeliveryClaimsClaimsSet();
        try {
            JSONObject claims = this.tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS_USERINFO);
            if (claims == null) {
                return null;
            }
            claimsSet.putAll((Map)claims);
        }
        catch (ParseException e) {
            this.log.error("Error parsing id token delivery claims {}", this.tokenClaimsSet.getClaim(KEY_DELIVERY_CLAIMS_USERINFO));
            return null;
        }
        return claimsSet;
    }

    public JSONArray getConsentableClaims() {
        return (JSONArray)this.tokenClaimsSet.getClaim(KEY_CONSENTABLE_CLAIMS);
    }

    public JSONArray getConsentedClaims() {
        return (JSONArray)this.tokenClaimsSet.getClaim(KEY_CONSENTED_CLAIMS);
    }

    @Nonnull
    public Scope getScope() {
        try {
            return Scope.parse((String)this.tokenClaimsSet.getStringClaim(KEY_SCOPE));
        }
        catch (ParseException e) {
            this.log.error("Error parsing scope in request {}", this.tokenClaimsSet.getClaim(KEY_SCOPE));
            return null;
        }
    }

    @Nonnull
    public String getCodeChallenge() {
        if (this.tokenClaimsSet.getClaim(KEY_CODE_CHALLENGE) == null) {
            return null;
        }
        return (String)this.tokenClaimsSet.getClaim(KEY_CODE_CHALLENGE);
    }

    @Nonnull
    public String getID() {
        return this.tokenClaimsSet.getJWTID();
    }

    @Nonnull
    public ClientID getClientID() {
        return new ClientID((String)this.tokenClaimsSet.getClaim(KEY_CLIENTID));
    }

    public static abstract class Builder<T extends TokenClaimsSet> {
        @Nonnull
        protected IdentifierGenerationStrategy idGen;
        @Nonnull
        protected ClientID rpId;
        @Nonnull
        protected String iss;
        @Nonnull
        protected String usrPrincipal;
        @Nonnull
        protected String sub;
        @Nonnull
        protected ACR acr;
        @Nonnull
        protected Instant iat;
        @Nonnull
        protected Instant exp;
        @Nonnull
        protected Instant authTime;
        @Nonnull
        protected URI redirect;
        @Nonnull
        protected Scope reqScope;
        @Nullable
        protected Nonce nonce;
        @Nullable
        protected ClaimsRequest claims;
        @Nullable
        protected ClaimsSet dlClaims;
        @Nullable
        protected ClaimsSet dlClaimsID;
        @Nullable
        protected ClaimsSet dlClaimsUI;
        @Nullable
        protected JSONArray cnsntlClaims;
        @Nullable
        protected JSONArray cnsntdClaims;
        @Nullable
        protected String codeChallenge;

        protected Builder(@Nonnull IdentifierGenerationStrategy idGenerator, @Nonnull ClientID clientID, @Nonnull String issuer, @Nonnull String userPrincipal, @Nonnull String subject, @Nonnull Instant issuedAt, @Nonnull Instant expiresAt, @Nonnull Instant authenticationTime, @Nonnull URI redirectURI, @Nonnull Scope scope) {
            this.idGen = idGenerator;
            this.rpId = clientID;
            this.iss = issuer;
            this.usrPrincipal = userPrincipal;
            this.sub = subject;
            this.iat = issuedAt;
            this.exp = expiresAt;
            this.authTime = authenticationTime;
            this.redirect = redirectURI;
            this.reqScope = scope;
        }

        public Builder<T> setACR(@Nullable ACR authenticationContextReference) {
            this.acr = authenticationContextReference;
            return this;
        }

        public Builder<T> setNonce(@Nullable Nonce requestNonce) {
            this.nonce = requestNonce;
            return this;
        }

        public Builder<T> setClaims(@Nullable ClaimsRequest requestedClaims) {
            this.claims = requestedClaims;
            return this;
        }

        public Builder<T> setDlClaims(@Nullable ClaimsSet deliveryClaims) {
            this.dlClaims = deliveryClaims;
            return this;
        }

        public Builder<T> setDlClaimsID(@Nullable ClaimsSet deliveryClaimsIDToken) {
            this.dlClaimsID = deliveryClaimsIDToken;
            return this;
        }

        public Builder<T> setDlClaimsUI(@Nullable ClaimsSet deliveryClaimsUserInfo) {
            this.dlClaimsUI = deliveryClaimsUserInfo;
            return this;
        }

        public Builder<T> setConsentableClaims(@Nullable JSONArray consentableClaims) {
            this.cnsntlClaims = consentableClaims;
            return this;
        }

        public Builder<T> setConsentedClaims(@Nullable JSONArray consentedClaims) {
            this.cnsntdClaims = consentedClaims;
            return this;
        }

        public Builder<T> setCodeChallenge(@Nullable String challenge) {
            this.codeChallenge = challenge;
            return this;
        }

        public abstract T build();
    }
}

