/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.attribute.transcoding;

import com.google.common.base.Strings;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.transcoding.AbstractAttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.geant.idpextension.oidc.attribute.transcoding.OIDCAttributeTranscoder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOIDCAttributeTranscoder
extends AbstractAttributeTranscoder<JSONObject>
implements OIDCAttributeTranscoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCAttributeTranscoder.class);

    public Class<JSONObject> getEncodedType() {
        return JSONObject.class;
    }

    @Nullable
    public String getEncodedName(@Nonnull TranscodingRule rule) {
        String name = (String)rule.getOrDefault("oidc.name", String.class, (Object)((String)rule.get("id", String.class)));
        if (name != null) {
            return "OIDC:" + name;
        }
        return null;
    }

    @Nullable
    public JSONObject doEncode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Class<? extends JSONObject> to, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        String attributeId = attribute.getId();
        this.log.trace("Beginning to encode attribute {}", (Object)attributeId);
        Object claimValues = this.encodeValues(profileRequestContext, attribute, rule);
        if (claimValues instanceof JSONArray) {
            this.log.trace("Encoded {} value(s) for attribute {}", (Object)((JSONArray)claimValues).size(), (Object)attributeId);
        } else {
            this.log.trace("Encoded {} value(s) for attribute {}", (Object)(claimValues != null ? 1 : 0), (Object)attributeId);
        }
        return this.buildClaim(profileRequestContext, attribute, rule, claimValues);
    }

    @Nonnull
    protected JSONObject buildClaim(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull @NonnullElements Object claimValues) throws AttributeEncodingException {
        if (claimValues == null) {
            throw new AttributeEncodingException("Unable to build OIDC claim with no value(s)");
        }
        String name = (String)rule.getOrDefault("oidc.name", String.class, (Object)attribute.getId());
        JSONObject claim = new JSONObject();
        claim.put((Object)name, claimValues);
        return claim;
    }

    @Nullable
    protected abstract Object encodeValues(@Nullable ProfileRequestContext var1, @Nonnull IdPAttribute var2, @Nonnull TranscodingRule var3) throws AttributeEncodingException;

    @Nullable
    public IdPAttribute doDecode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull JSONObject input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        String attributeName = this.getEncodedName(rule);
        this.log.trace("Beginning to decode claim {}", (Object)attributeName);
        List<IdPAttributeValue> idpAttributeValues = this.decodeValues(profileRequestContext, input.get((Object)attributeName), rule);
        this.log.trace("Decoded {} values for claim {}", (Object)idpAttributeValues.size(), (Object)attributeName);
        return this.buildIdPAttribute(profileRequestContext, input, rule, idpAttributeValues);
    }

    @Nonnull
    protected IdPAttribute buildIdPAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nonnull JSONObject claim, @Nonnull TranscodingRule rule, @Nonnull @NonnullElements List<IdPAttributeValue> attributeValues) throws AttributeDecodingException {
        String id = (String)rule.get("id", String.class);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new AttributeDecodingException("Required transcoder property 'id' not found");
        }
        String name = (String)rule.getOrDefault("oidc.name", String.class, (Object)id);
        Object claimValue = claim.get((Object)name);
        if (claimValue instanceof ClaimsRequest.Entry) {
            IdPRequestedAttribute idpAttribute = new IdPRequestedAttribute(id);
            idpAttribute.setRequired(ClaimRequirement.ESSENTIAL.equals((Object)((ClaimsRequest.Entry)claimValue).getClaimRequirement()));
            idpAttribute.setValues(attributeValues);
            return idpAttribute;
        }
        IdPAttribute idpAttribute = new IdPAttribute(id);
        idpAttribute.setValues(attributeValues);
        return idpAttribute;
    }

    @Nonnull
    @NonnullElements
    protected abstract List<IdPAttributeValue> decodeValues(@Nullable ProfileRequestContext var1, @Nonnull Object var2, @Nonnull TranscodingRule var3) throws AttributeDecodingException;

    public static class NamingFunction
    implements Function<JSONObject, String> {
        @Override
        @Nullable
        public String apply(@Nullable JSONObject input) {
            if (input == null) {
                return null;
            }
            Set keys = input.keySet();
            if (keys.size() != 1) {
                return null;
            }
            return "OIDC:" + (String)keys.iterator().next();
        }
    }
}

