/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.resolver;

import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.client.HttpClient;
import org.geant.idpextension.oidc.metadata.support.RemoteJwkUtils;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageCapabilitiesEx;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteJwkSetCache
extends AbstractIdentifiableInitializableComponent {
    public static final String CONTEXT_NAME = "oidcRemoteJwkSetContents";
    private final Logger log = LoggerFactory.getLogger(RemoteJwkSetCache.class);
    private StorageService storage;
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    @NonnullAfterInit
    public StorageService getStorage() {
        return this.storage;
    }

    public void setStorage(@Nonnull StorageService storageService) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storage = (StorageService)Constraint.isNotNull((Object)storageService, (String)"StorageService cannot be null");
        StorageCapabilities caps = this.storage.getCapabilities();
        if (caps instanceof StorageCapabilitiesEx) {
            Constraint.isTrue((boolean)((StorageCapabilitiesEx)caps).isServerSide(), (String)"StorageService cannot be client-side");
        }
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClientSecurityParameters = params;
    }

    public void doInitialize() throws ComponentInitializationException {
        if (this.storage == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient cannot be null");
        }
    }

    public JWKSet fetch(@Nonnull URI uri, @Nonnull Instant expires) {
        return this.fetch(CONTEXT_NAME, uri, expires);
    }

    @Nullable
    public JWKSet fetch(@Nonnull @NotEmpty String context, @Nonnull URI uri, @Nonnull Instant expires) {
        String key = uri.toString();
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return null;
        }
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("Value '{}' was not in the cache, fetching it", (Object)key);
                JWKSet remoteJwkSet = RemoteJwkUtils.fetchRemoteJwkSet("RemoteJwkSetCache", uri, this.httpClient, this.httpClientSecurityParameters);
                if (remoteJwkSet != null && remoteJwkSet.getKeys() != null && !remoteJwkSet.getKeys().isEmpty()) {
                    this.storage.create(context, key, remoteJwkSet.toString(), Long.valueOf(expires.toEpochMilli()));
                    return remoteJwkSet;
                }
            } else {
                JWKSet cachedSet = JWKSet.parse((String)entry.getValue());
                this.log.debug("Cached value found and will be returned, expires at {}", (Object)entry.getExpiration());
                return cachedSet;
            }
            this.log.warn("Could not find any remote keys from {}", (Object)key);
        }
        catch (IOException | ParseException e) {
            this.log.error("Exception reading/writing to storage service", (Throwable)e);
        }
        return null;
    }
}

