/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestStateLookupFunction
extends AbstractAuthenticationRequestLookupFunction<State> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestStateLookupFunction.class);

    @Override
    State doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("state") != null) {
                Object state = this.getRequestObject().getJWTClaimsSet().getClaim("state");
                if (state instanceof String) {
                    return new State((String)state);
                }
                this.log.error("state claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse state from request object state value");
            return null;
        }
        if (req.getState() == null) {
            return null;
        }
        return new State(req.getState().getValue());
    }
}

