/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;
import org.geant.idpextension.oidc.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestedClaimsLookupFunction
extends AbstractAuthenticationRequestLookupFunction<ClaimsRequest> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedClaimsLookupFunction.class);

    @Override
    ClaimsRequest doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("claims") != null) {
                Object claims = this.getRequestObject().getJWTClaimsSet().getClaim("claims");
                if (claims instanceof JSONObject) {
                    return ClaimsRequest.parse((JSONObject)((JSONObject)claims));
                }
                this.log.error("claims claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("unable to parse claims claim {}", (Object)e.getMessage());
            return null;
        }
        if (req.getClaims() == null) {
            return null;
        }
        ClaimsRequest request = new ClaimsRequest();
        request.add(req.getClaims());
        return request;
    }
}

