/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestedScopeLookupFunction
extends AbstractAuthenticationRequestLookupFunction<Scope> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedScopeLookupFunction.class);

    @Override
    Scope doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("scope") != null) {
                return Scope.parse((String)((String)this.getRequestObject().getJWTClaimsSet().getClaim("scope")));
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse scope from request object scope value");
            return null;
        }
        Scope requestParameterScope = new Scope();
        requestParameterScope.addAll((Collection)req.getScope());
        return requestParameterScope;
    }
}

