/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.navigate.OIDCClientRegistrationRequestMetadataLookupFunction;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStatementsLookupFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, Map<String, String>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataStatementsLookupFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientMetadata> oidcMetadataLookupStrategy = new OIDCClientRegistrationRequestMetadataLookupFunction();

    public void setMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientMetadata> strategy) {
        this.oidcMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadata lookup strategy cannot be null");
    }

    @Nullable
    public Map<String, String> apply(@Nullable ProfileRequestContext input) {
        OIDCClientMetadata metadata = this.oidcMetadataLookupStrategy.apply(input);
        Object rawStatements = metadata.getCustomField("metadata_statements");
        if (rawStatements != null && rawStatements instanceof JSONObject) {
            JSONObject statements = (JSONObject)rawStatements;
            HashMap<String, String> parsedStatements = new HashMap<String, String>();
            for (Map.Entry entry : statements.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value != null && value instanceof String) {
                    this.log.debug("Adding a metadata statement for federation {}", (Object)key);
                    parsedStatements.put(key, (String)value);
                    continue;
                }
                this.log.debug("Ignoring unexpected format for value {}", value);
            }
            return parsedStatements;
        }
        this.log.debug("Could not find metadata_statements from the metadata");
        return null;
    }
}

